/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.controller;

import cn.herodotus.engine.assistant.definition.domain.Result;
import cn.herodotus.engine.assistant.definition.domain.base.Entity;
import cn.herodotus.engine.data.core.service.WriteableService;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Application;
import cn.herodotus.engine.oauth2.management.service.OAuth2ApplicationService;
import cn.herodotus.engine.rest.core.controller.BaseWriteableRestController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/authorize/application"})
@Tags(value={@Tag(name="OAuth2 \u8ba4\u8bc1\u670d\u52a1\u63a5\u53e3"), @Tag(name="OAuth2 \u5e94\u7528\u7ba1\u7406\u63a5\u53e3")})
public class OAuth2ApplicationController
extends BaseWriteableRestController<OAuth2Application, String> {
    private final OAuth2ApplicationService applicationService;

    public OAuth2ApplicationController(OAuth2ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    public WriteableService<OAuth2Application, String> getWriteableService() {
        return this.applicationService;
    }

    @Operation(summary="\u7ed9\u5e94\u7528\u5206\u914dScope", description="\u7ed9\u5e94\u7528\u5206\u914dScope")
    @Parameters(value={@Parameter(name="appKey", required=true, description="appKey"), @Parameter(name="scopes[]", required=true, description="Scope\u5bf9\u8c61\u7ec4\u6210\u7684\u6570\u7ec4")})
    @PutMapping
    public Result<OAuth2Application> authorize(@RequestParam(name="applicationId") String scopeId, @RequestParam(name="scopes[]") String[] scopes) {
        OAuth2Application application = this.applicationService.authorize(scopeId, scopes);
        return this.result((Entity)application);
    }
}

