/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.controller;

import cn.herodotus.engine.assistant.definition.domain.Result;
import cn.herodotus.engine.assistant.definition.domain.base.Entity;
import cn.herodotus.engine.data.core.service.WriteableService;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Device;
import cn.herodotus.engine.oauth2.management.service.OAuth2DeviceService;
import cn.herodotus.engine.rest.core.controller.BaseWriteableRestController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/authorize/device"})
@Tags(value={@Tag(name="OAuth2 \u8ba4\u8bc1\u670d\u52a1\u63a5\u53e3"), @Tag(name="\u7269\u8054\u7f51\u7ba1\u7406\u63a5\u53e3"), @Tag(name="\u7269\u8054\u7f51\u8bbe\u5907\u63a5\u53e3")})
public class OAuth2DeviceController
extends BaseWriteableRestController<OAuth2Device, String> {
    private final OAuth2DeviceService deviceService;

    public OAuth2DeviceController(OAuth2DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    public WriteableService<OAuth2Device, String> getWriteableService() {
        return this.deviceService;
    }

    @Operation(summary="\u7ed9\u8bbe\u5907\u5206\u914dScope", description="\u7ed9\u8bbe\u5907\u5206\u914dScope")
    @Parameters(value={@Parameter(name="deviceId", required=true, description="\u8bbe\u5907ID"), @Parameter(name="scopes[]", required=true, description="Scope\u5bf9\u8c61\u7ec4\u6210\u7684\u6570\u7ec4")})
    @PutMapping
    public Result<OAuth2Device> authorize(@RequestParam(name="deviceId") String deviceId, @RequestParam(name="scopes[]") String[] scopes) {
        OAuth2Device device = this.deviceService.authorize(deviceId, scopes);
        return this.result((Entity)device);
    }
}

