/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.entity;

import cn.herodotus.engine.data.core.entity.BaseEntity;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.UuidGenerator;

@Schema(name="\u7269\u8054\u7f51\u4ea7\u54c1")
@Entity
@Table(name="oauth2_product", uniqueConstraints={@UniqueConstraint(columnNames={"product_key"})}, indexes={@Index(name="oauth2_product_pid_idx", columnList="product_id"), @Index(name="oauth2_product_ipk_idx", columnList="product_key")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:oauth2:product")
public class OAuth2Product
extends BaseEntity {
    @Id
    @UuidGenerator
    @Column(name="product_id", length=64)
    private String productId;
    @Column(name="product_key", length=32, unique=true)
    private String productKey;

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public void setProductKey(String productKey) {
        this.productKey = productKey;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("productId", (Object)this.productId).add("productKey", (Object)this.productKey).toString();
    }
}

