/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.service;

import cn.herodotus.engine.assistant.definition.domain.base.Entity;
import cn.herodotus.engine.data.core.repository.BaseRepository;
import cn.herodotus.engine.data.core.service.BaseService;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Compliance;
import cn.herodotus.engine.oauth2.management.repository.OAuth2ComplianceRepository;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.http.server.servlet.JakartaServletUtil;
import org.dromara.hutool.http.useragent.UserAgent;
import org.dromara.hutool.http.useragent.UserAgentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class OAuth2ComplianceService
extends BaseService<OAuth2Compliance, String> {
    private static final Logger log = LoggerFactory.getLogger(OAuth2ComplianceService.class);
    private final OAuth2ComplianceRepository complianceRepository;

    public OAuth2ComplianceService(OAuth2ComplianceRepository complianceRepository) {
        this.complianceRepository = complianceRepository;
    }

    public BaseRepository<OAuth2Compliance, String> getRepository() {
        return this.complianceRepository;
    }

    public Page<OAuth2Compliance> findByCondition(int pageNumber, int pageSize, String principalName, String clientId, String ip) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (StringUtils.isNotBlank((CharSequence)principalName)) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("principalName"), (Object)principalName));
            }
            if (StringUtils.isNotBlank((CharSequence)clientId)) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("clientId"), (Object)clientId));
            }
            if (StringUtils.isNotBlank((CharSequence)ip)) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("ip"), (Object)ip));
            }
            Predicate[] predicateArray = new Predicate[predicates.size()];
            criteriaQuery.where((Expression)criteriaBuilder.and(predicates.toArray(predicateArray)));
            return criteriaQuery.getRestriction();
        };
        return this.findByPage(specification, (Pageable)pageable);
    }

    public OAuth2Compliance save(String principalName, String clientId, String operation, HttpServletRequest request) {
        OAuth2Compliance compliance = this.toEntity(principalName, clientId, operation, request);
        log.debug("[Herodotus] |- Sign in user is [{}]", (Object)compliance);
        return (OAuth2Compliance)super.save((Entity)compliance);
    }

    private UserAgent getUserAgent(HttpServletRequest request) {
        return UserAgentUtil.parse((String)request.getHeader("User-Agent"));
    }

    private String getIp(HttpServletRequest request) {
        return JakartaServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[]{""});
    }

    public OAuth2Compliance toEntity(String principalName, String clientId, String operation, HttpServletRequest request) {
        OAuth2Compliance audit = new OAuth2Compliance();
        audit.setPrincipalName(principalName);
        audit.setClientId(clientId);
        audit.setOperation(operation);
        UserAgent userAgent = this.getUserAgent(request);
        if (ObjectUtils.isNotEmpty((Object)userAgent)) {
            audit.setIp(this.getIp(request));
            audit.setMobile(userAgent.isMobile());
            audit.setOsName(userAgent.getOs().getName());
            audit.setBrowserName(userAgent.getBrowser().getName());
            audit.setMobileBrowser(userAgent.getBrowser().isMobile());
            audit.setEngineName(userAgent.getEngine().getName());
            audit.setMobilePlatform(userAgent.getPlatform().isMobile());
            audit.setIphoneOrIpod(userAgent.getPlatform().isIPhoneOrIPod());
            audit.setIpad(userAgent.getPlatform().isIPad());
            audit.setIos(userAgent.getPlatform().isIos());
            audit.setAndroid(userAgent.getPlatform().isAndroid());
        }
        return audit;
    }
}

