/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.service;

import cn.herodotus.engine.assistant.core.definition.domain.Entity;
import cn.herodotus.engine.assistant.core.exception.transaction.TransactionalRollbackException;
import cn.herodotus.engine.data.core.repository.BaseRepository;
import cn.herodotus.engine.data.core.service.BaseService;
import cn.herodotus.engine.oauth2.data.jpa.repository.HerodotusRegisteredClientRepository;
import cn.herodotus.engine.oauth2.management.converter.OAuth2DeviceToRegisteredClientConverter;
import cn.herodotus.engine.oauth2.management.converter.RegisteredClientToOAuth2DeviceConverter;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Device;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Scope;
import cn.herodotus.engine.oauth2.management.repository.OAuth2DeviceRepository;
import cn.herodotus.engine.oauth2.management.service.OAuth2ApplicationService;
import cn.herodotus.engine.oauth2.management.service.OAuth2ScopeService;
import java.io.Serializable;
import java.util.HashSet;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.oidc.OidcClientRegistration;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OAuth2DeviceService
extends BaseService<OAuth2Device, String> {
    private static final Logger log = LoggerFactory.getLogger(OAuth2ApplicationService.class);
    private final RegisteredClientRepository registeredClientRepository;
    private final HerodotusRegisteredClientRepository herodotusRegisteredClientRepository;
    private final OAuth2DeviceRepository deviceRepository;
    private final Converter<OAuth2Device, RegisteredClient> oauth2DeviceToRegisteredClientConverter;
    private final Converter<RegisteredClient, OAuth2Device> registeredClientToOAuth2DeviceConverter;

    public OAuth2DeviceService(RegisteredClientRepository registeredClientRepository, HerodotusRegisteredClientRepository herodotusRegisteredClientRepository, OAuth2DeviceRepository deviceRepository, OAuth2ScopeService scopeService) {
        this.registeredClientRepository = registeredClientRepository;
        this.herodotusRegisteredClientRepository = herodotusRegisteredClientRepository;
        this.deviceRepository = deviceRepository;
        this.oauth2DeviceToRegisteredClientConverter = new OAuth2DeviceToRegisteredClientConverter();
        this.registeredClientToOAuth2DeviceConverter = new RegisteredClientToOAuth2DeviceConverter(scopeService);
    }

    public BaseRepository<OAuth2Device, String> getRepository() {
        return this.deviceRepository;
    }

    @Transactional(rollbackFor={TransactionalRollbackException.class})
    public OAuth2Device saveAndFlush(OAuth2Device entity) {
        OAuth2Device device = (OAuth2Device)super.saveAndFlush((Entity)entity);
        if (ObjectUtils.isNotEmpty((Object)((Object)device))) {
            this.registeredClientRepository.save((RegisteredClient)this.oauth2DeviceToRegisteredClientConverter.convert((Object)device));
            return device;
        }
        log.error("[Herodotus] |- OAuth2DeviceService saveOrUpdate error, rollback data!");
        throw new NullPointerException("save or update OAuth2DeviceService failed");
    }

    @Transactional(rollbackFor={TransactionalRollbackException.class})
    public void deleteById(String id) {
        super.deleteById((Serializable)((Object)id));
        this.herodotusRegisteredClientRepository.deleteById((Serializable)((Object)id));
    }

    @Transactional(rollbackFor={TransactionalRollbackException.class})
    public OAuth2Device authorize(String deviceId, String[] scopeIds) {
        HashSet<OAuth2Scope> scopes = new HashSet<OAuth2Scope>();
        for (String scopeId : scopeIds) {
            OAuth2Scope scope = new OAuth2Scope();
            scope.setScopeId(scopeId);
            scopes.add(scope);
        }
        OAuth2Device oldDevice = (OAuth2Device)this.findById((Serializable)((Object)deviceId));
        oldDevice.setScopes(scopes);
        return this.saveAndFlush(oldDevice);
    }

    public boolean sync(OidcClientRegistration oidcClientRegistration) {
        OAuth2Device oauth2Device;
        RegisteredClient registeredClient = this.registeredClientRepository.findByClientId(oidcClientRegistration.getClientId());
        if (ObjectUtils.isNotEmpty((Object)registeredClient) && ObjectUtils.isNotEmpty((Object)((Object)(oauth2Device = (OAuth2Device)((Object)this.registeredClientToOAuth2DeviceConverter.convert((Object)registeredClient)))))) {
            OAuth2Device result = (OAuth2Device)((Object)this.deviceRepository.save((Object)oauth2Device));
            return ObjectUtils.isNotEmpty((Object)((Object)result));
        }
        return false;
    }

    public boolean activate(String clientId, boolean isActivated) {
        int result = this.deviceRepository.activate(clientId, isActivated);
        return result != 0;
    }
}

