/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.entity;

import cn.herodotus.engine.data.core.entity.BaseEntity;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.UuidGenerator;

@Entity
@Table(name="oauth2_compliance", indexes={@Index(name="oauth2_compliance_id_idx", columnList="compliance_id")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:oauth2:compliance")
public class OAuth2Compliance
extends BaseEntity {
    @Id
    @UuidGenerator
    @Column(name="compliance_id", length=64)
    private String complianceId;
    @Column(name="principal_name", length=128)
    private String principalName;
    @Column(name="client_id", length=100)
    private String clientId;
    @Column(name="ip_address", length=20)
    private String ip;
    @Column(name="is_mobile")
    private Boolean mobile = false;
    @Column(name="os_name", length=200)
    private String osName;
    @Column(name="browser_name", length=50)
    private String browserName;
    @Column(name="is_mobile_browser")
    private Boolean mobileBrowser = false;
    @Column(name="engine_name", length=50)
    private String engineName;
    @Column(name="is_mobile_platform")
    private Boolean mobilePlatform = false;
    @Column(name="is_iphone_or_ipod")
    private Boolean iphoneOrIpod = false;
    @Column(name="is_ipad")
    private Boolean ipad = false;
    @Column(name="is_ios")
    private Boolean ios = false;
    @Column(name="is_android")
    private Boolean android = false;
    @Column(name="operation")
    private String operation;

    public String getComplianceId() {
        return this.complianceId;
    }

    public void setComplianceId(String complianceId) {
        this.complianceId = complianceId;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Boolean getMobile() {
        return this.mobile;
    }

    public void setMobile(Boolean mobile) {
        this.mobile = mobile;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public void setBrowserName(String browserName) {
        this.browserName = browserName;
    }

    public Boolean getMobileBrowser() {
        return this.mobileBrowser;
    }

    public void setMobileBrowser(Boolean mobileBrowser) {
        this.mobileBrowser = mobileBrowser;
    }

    public String getEngineName() {
        return this.engineName;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public Boolean getMobilePlatform() {
        return this.mobilePlatform;
    }

    public void setMobilePlatform(Boolean mobilePlatform) {
        this.mobilePlatform = mobilePlatform;
    }

    public Boolean getIphoneOrIpod() {
        return this.iphoneOrIpod;
    }

    public void setIphoneOrIpod(Boolean iphoneOrIpod) {
        this.iphoneOrIpod = iphoneOrIpod;
    }

    public Boolean getIpad() {
        return this.ipad;
    }

    public void setIpad(Boolean ipad) {
        this.ipad = ipad;
    }

    public Boolean getIos() {
        return this.ios;
    }

    public void setIos(Boolean ios) {
        this.ios = ios;
    }

    public Boolean getAndroid() {
        return this.android;
    }

    public void setAndroid(Boolean android) {
        this.android = android;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OAuth2Compliance that = (OAuth2Compliance)((Object)o);
        return Objects.equal((Object)this.complianceId, (Object)that.complianceId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.complianceId});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("complianceId", (Object)this.complianceId).add("principalName", (Object)this.principalName).add("clientId", (Object)this.clientId).add("ip", (Object)this.ip).add("mobile", (Object)this.mobile).add("osName", (Object)this.osName).add("browserName", (Object)this.browserName).add("mobileBrowser", (Object)this.mobileBrowser).add("engineName", (Object)this.engineName).add("mobilePlatform", (Object)this.mobilePlatform).add("iphoneOrIpod", (Object)this.iphoneOrIpod).add("ipad", (Object)this.ipad).add("ios", (Object)this.ios).add("android", (Object)this.android).add("operation", (Object)this.operation).toString();
    }
}

