/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.service;

import cn.herodotus.engine.assistant.core.domain.SecretKey;
import cn.herodotus.engine.oauth2.core.utils.SecurityUtils;
import cn.herodotus.engine.rest.protect.crypto.processor.HttpCryptoProcessor;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.stereotype.Service;

@Service
public class InterfaceSecurityService {
    private final HttpCryptoProcessor httpCryptoProcessor;
    private final RegisteredClientRepository registeredClientRepository;

    public InterfaceSecurityService(HttpCryptoProcessor httpCryptoProcessor, RegisteredClientRepository registeredClientRepository) {
        this.httpCryptoProcessor = httpCryptoProcessor;
        this.registeredClientRepository = registeredClientRepository;
    }

    private RegisteredClient validateClient(String clientId, String clientSecret) {
        RegisteredClient registeredClient = this.registeredClientRepository.findByClientId(clientId);
        boolean isMatch = false;
        if (ObjectUtils.isNotEmpty((Object)registeredClient)) {
            isMatch = SecurityUtils.matches((String)clientSecret, (String)registeredClient.getClientSecret());
        }
        if (!isMatch) {
            throw new OAuth2AuthenticationException("invalid_client");
        }
        return registeredClient;
    }

    public SecretKey createSecretKey(String clientId, String clientSecret, String sessionId) {
        RegisteredClient registeredClient = this.validateClient(clientId, clientSecret);
        return this.httpCryptoProcessor.createSecretKey(sessionId, registeredClient.getTokenSettings().getAccessTokenTimeToLive());
    }

    public String exchange(String sessionId, String confidentialBase64) {
        return this.httpCryptoProcessor.exchange(sessionId, confidentialBase64);
    }
}

