/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.controller;

import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.captcha.core.dto.Captcha;
import cn.herodotus.engine.captcha.core.dto.Verification;
import cn.herodotus.engine.captcha.core.processor.CaptchaRendererFactory;
import cn.herodotus.engine.rest.core.annotation.AccessLimited;
import cn.herodotus.engine.rest.core.annotation.Crypto;
import cn.herodotus.engine.rest.core.annotation.Idempotent;
import cn.herodotus.engine.rest.core.controller.Controller;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open/captcha"})
@Validated
@Tags(value={@Tag(name="OAuth2 \u8ba4\u8bc1\u670d\u52a1\u5668\u63a5\u53e3"), @Tag(name="OAuth2 \u8ba4\u8bc1\u670d\u52a1\u5668\u5f00\u653e\u63a5\u53e3"), @Tag(name="\u9a8c\u8bc1\u7801\u63a5\u53e3")})
public class CaptchaController
implements Controller {
    private final CaptchaRendererFactory captchaRendererFactory;

    public CaptchaController(CaptchaRendererFactory captchaRendererFactory) {
        this.captchaRendererFactory = captchaRendererFactory;
    }

    @AccessLimited
    @Operation(summary="\u83b7\u53d6\u9a8c\u8bc1\u7801", description="\u901a\u8fc7\u4f20\u9012\u8eab\u4efd\u4fe1\u606f\uff08\u7c7b\u4f3c\u4e8eSession\u6807\u8bc6\uff09", responses={@ApiResponse(description="\u9a8c\u8bc1\u7801\u56fe\u5f62\u4fe1\u606f", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))})})
    @Parameters(value={@Parameter(name="identity", required=true, in=ParameterIn.PATH, description="\u8eab\u4efd\u4fe1\u606f"), @Parameter(name="category", required=true, in=ParameterIn.PATH, description="\u9a8c\u8bc1\u7801\u7c7b\u578b")})
    @GetMapping
    public Result<Captcha> create(@NotBlank(message="\u8eab\u4efd\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u8eab\u4efd\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a") String identity, @NotBlank(message="\u9a8c\u8bc1\u7801\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u9a8c\u8bc1\u7801\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") String category) {
        Captcha captcha = this.captchaRendererFactory.getCaptcha(identity, category);
        if (ObjectUtils.isNotEmpty((Object)captcha)) {
            return Result.success((String)"\u9a8c\u8bc1\u7801\u521b\u5efa\u6210\u529f", (Object)captcha);
        }
        return Result.failure((String)"\u9a8c\u8bc1\u7801\u521b\u5efa\u5931\u8d25");
    }

    @Idempotent
    @Crypto(responseEncrypt=false)
    @Operation(summary="\u9a8c\u8bc1\u7801\u9a8c\u8bc1", description="\u9a8c\u8bc1\u9a8c\u8bc1\u7801\u8fd4\u56de\u6570\u636e\u662f\u5426\u6b63\u786e\u3002\u4f7f\u7528\u52a0\u5bc6\u4fe1\u606f", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u9a8c\u8bc1\u7ed3\u679c", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="jigsawVerification", required=true, description="\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u53c2\u6570", schema=@Schema(implementation=Verification.class))})
    @PostMapping
    public Result<Boolean> check(@Valid @RequestBody Verification verification) {
        boolean isSuccess = this.captchaRendererFactory.verify(verification);
        if (isSuccess) {
            return Result.success((String)"\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u6210\u529f", (Object)true);
        }
        return Result.failure((String)"\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u5931\u8d25", (Object)true);
    }
}

