/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.controller;

import cn.herodotus.engine.assistant.core.domain.Option;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Application;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Scope;
import cn.herodotus.engine.oauth2.management.service.OAuth2ApplicationService;
import cn.herodotus.engine.oauth2.management.service.OAuth2ScopeService;
import cn.herodotus.engine.rest.core.properties.EndpointProperties;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsent;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ConsentController {
    private final OAuth2ApplicationService applicationService;
    private final OAuth2AuthorizationConsentService authorizationConsentService;
    private final OAuth2ScopeService scopeService;
    private final EndpointProperties endpointProperties;
    private Map<String, OAuth2Scope> dictionaries;

    public ConsentController(OAuth2ApplicationService applicationService, OAuth2AuthorizationConsentService authorizationConsentService, OAuth2ScopeService scopeService, EndpointProperties endpointProperties) {
        this.applicationService = applicationService;
        this.authorizationConsentService = authorizationConsentService;
        this.scopeService = scopeService;
        this.endpointProperties = endpointProperties;
        this.initDictionaries();
    }

    @GetMapping(value={"/oauth2/consent"})
    public String consent(Principal principal, Model model, @RequestParam(value="client_id") String clientId, @RequestParam(value="scope") String scope, @RequestParam(value="state") String state, @RequestParam(value="user_code", required=false) String userCode) {
        HashSet<String> scopesToApprove = new HashSet<String>();
        HashSet<String> previouslyApprovedScopes = new HashSet<String>();
        OAuth2Application application = this.applicationService.findByClientId(clientId);
        OAuth2AuthorizationConsent currentAuthorizationConsent = this.authorizationConsentService.findById(clientId, principal.getName());
        Set authorizedScopes = Optional.ofNullable(currentAuthorizationConsent).map(OAuth2AuthorizationConsent::getScopes).orElse(Collections.emptySet());
        for (String requestedScope : StringUtils.delimitedListToStringArray((String)scope, (String)" ")) {
            if ("openid".equals(requestedScope)) continue;
            if (authorizedScopes.contains(requestedScope)) {
                previouslyApprovedScopes.add(requestedScope);
                continue;
            }
            scopesToApprove.add(requestedScope);
        }
        Set redirectUris = StringUtils.commaDelimitedListToSet((String)application.getRedirectUris());
        model.addAttribute("clientId", (Object)clientId);
        model.addAttribute("state", (Object)state);
        model.addAttribute("scopesToAuthorize", this.withDescription(scopesToApprove));
        model.addAttribute("scopesPreviouslyAuthorized", this.withDescription(previouslyApprovedScopes));
        model.addAttribute("principalName", (Object)principal.getName());
        model.addAttribute("applicationName", (Object)application.getApplicationName());
        model.addAttribute("logo", (Object)application.getLogo());
        model.addAttribute("redirectUri", redirectUris.iterator().next());
        model.addAttribute("userCode", (Object)userCode);
        String action = this.endpointProperties.getAuthorizationEndpoint();
        if (StringUtils.hasText((String)userCode)) {
            action = this.endpointProperties.getDeviceVerificationEndpoint();
        }
        model.addAttribute("action", (Object)action);
        return "consent";
    }

    private void initDictionaries() {
        List scopes = this.scopeService.findAll();
        if (CollectionUtils.isNotEmpty((Collection)scopes) && (MapUtils.isEmpty(this.dictionaries) || scopes.size() != this.dictionaries.size())) {
            this.dictionaries = scopes.stream().collect(Collectors.toMap(OAuth2Scope::getScopeCode, item -> item));
        }
    }

    private Set<Option> withDescription(Set<String> scopes) {
        if (CollectionUtils.isNotEmpty(scopes)) {
            return scopes.stream().map(item -> this.scopeToOption(this.dictionaries.get(item))).collect(Collectors.toSet());
        }
        return new HashSet<Option>();
    }

    private Option scopeToOption(OAuth2Scope scope) {
        Option option = new Option();
        String label = scope.getDescription() == null ? scope.getScopeName() : scope.getDescription();
        option.setLabel(label);
        option.setValue(scope.getScopeCode());
        return option;
    }
}

