/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.service;

import cn.herodotus.engine.assistant.core.definition.domain.Entity;
import cn.herodotus.engine.assistant.core.exception.transaction.TransactionalRollbackException;
import cn.herodotus.engine.data.core.repository.BaseRepository;
import cn.herodotus.engine.data.core.service.BaseService;
import cn.herodotus.engine.oauth2.data.jpa.repository.HerodotusRegisteredClientRepository;
import cn.herodotus.engine.oauth2.management.converter.OAuth2ApplicationToRegisteredClientConverter;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Application;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Scope;
import cn.herodotus.engine.oauth2.management.repository.OAuth2ApplicationRepository;
import java.io.Serializable;
import java.util.HashSet;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OAuth2ApplicationService
extends BaseService<OAuth2Application, String> {
    private static final Logger log = LoggerFactory.getLogger(OAuth2ApplicationService.class);
    private final RegisteredClientRepository registeredClientRepository;
    private final HerodotusRegisteredClientRepository herodotusRegisteredClientRepository;
    private final OAuth2ApplicationRepository applicationRepository;
    private final Converter<OAuth2Application, RegisteredClient> objectConverter;

    public OAuth2ApplicationService(RegisteredClientRepository registeredClientRepository, HerodotusRegisteredClientRepository herodotusRegisteredClientRepository, OAuth2ApplicationRepository applicationRepository) {
        this.registeredClientRepository = registeredClientRepository;
        this.herodotusRegisteredClientRepository = herodotusRegisteredClientRepository;
        this.applicationRepository = applicationRepository;
        this.objectConverter = new OAuth2ApplicationToRegisteredClientConverter();
    }

    public BaseRepository<OAuth2Application, String> getRepository() {
        return this.applicationRepository;
    }

    public OAuth2Application saveAndFlush(OAuth2Application entity) {
        OAuth2Application application = (OAuth2Application)super.saveAndFlush((Entity)entity);
        if (ObjectUtils.isNotEmpty((Object)((Object)application))) {
            this.registeredClientRepository.save((RegisteredClient)this.objectConverter.convert((Object)application));
            log.debug("[Herodotus] |- OAuth2ApplicationService saveOrUpdate.");
            return application;
        }
        log.error("[Herodotus] |- OAuth2ApplicationService saveOrUpdate error, rollback data!");
        throw new NullPointerException("save or update OAuth2Application failed");
    }

    @Transactional(rollbackFor={TransactionalRollbackException.class})
    public void deleteById(String id) {
        super.deleteById((Serializable)((Object)id));
        this.herodotusRegisteredClientRepository.deleteById((Serializable)((Object)id));
    }

    @Transactional(rollbackFor={TransactionalRollbackException.class})
    public OAuth2Application authorize(String applicationId, String[] scopeIds) {
        HashSet<OAuth2Scope> scopes = new HashSet<OAuth2Scope>();
        for (String scopeId : scopeIds) {
            OAuth2Scope scope = new OAuth2Scope();
            scope.setScopeId(scopeId);
            scopes.add(scope);
        }
        OAuth2Application oldApplication = (OAuth2Application)this.findById((Serializable)((Object)applicationId));
        oldApplication.setScopes(scopes);
        return this.saveAndFlush(oldApplication);
    }

    public OAuth2Application findByClientId(String clientId) {
        return this.applicationRepository.findByClientId(clientId);
    }
}

