/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.entity;

import cn.herodotus.engine.data.core.entity.BaseSysEntity;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Permission;
import com.google.common.base.MoreObjects;
import jakarta.persistence.Cacheable;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.UuidGenerator;

@Entity
@Table(name="oauth2_scope", uniqueConstraints={@UniqueConstraint(columnNames={"scope_code"})}, indexes={@Index(name="oauth2_scope_id_idx", columnList="scope_id"), @Index(name="oauth2_scope_code_idx", columnList="scope_code")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:oauth2:scope")
public class OAuth2Scope
extends BaseSysEntity {
    @Id
    @UuidGenerator
    @Column(name="scope_id", length=64)
    private String scopeId;
    @Column(name="scope_code", length=128, unique=true)
    private String scopeCode;
    @Column(name="scope_name", length=128)
    private String scopeName;
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:oauth2:permission")
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.DETACH, CascadeType.REMOVE, CascadeType.MERGE}, fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SUBSELECT)
    @JoinTable(name="oauth2_scope_permission", joinColumns={@JoinColumn(name="scope_id")}, inverseJoinColumns={@JoinColumn(name="permission_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"scope_id", "permission_id"})}, indexes={@Index(name="oauth2_scope_permission_sid_idx", columnList="scope_id"), @Index(name="oauth2_scope_permission_pid_idx", columnList="permission_id")})
    private Set<OAuth2Permission> permissions = new HashSet<OAuth2Permission>();

    public String getScopeId() {
        return this.scopeId;
    }

    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public String getScopeCode() {
        return this.scopeCode;
    }

    public void setScopeCode(String scopeCode) {
        this.scopeCode = scopeCode;
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public void setScopeName(String scopeName) {
        this.scopeName = scopeName;
    }

    public Set<OAuth2Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<OAuth2Permission> permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OAuth2Scope that = (OAuth2Scope)((Object)o);
        return new EqualsBuilder().append((Object)this.getScopeId(), (Object)that.getScopeId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getScopeId()).toHashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("scopeId", (Object)this.scopeId).add("scopeCode", (Object)this.scopeCode).add("scopeName", (Object)this.scopeName).toString();
    }
}

