/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.definition;

import cn.herodotus.engine.oauth2.core.enums.AllJwsAlgorithm;
import cn.herodotus.engine.oauth2.core.enums.SignatureJwsAlgorithm;
import cn.herodotus.engine.oauth2.core.enums.TokenFormat;
import cn.herodotus.engine.oauth2.data.jpa.definition.domain.AbstractRegisteredClient;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Scope;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.MappedSuperclass;
import java.time.Duration;
import java.util.Set;
import org.dromara.hutool.core.data.id.IdUtil;

@MappedSuperclass
public abstract class AbstractOAuth2RegisteredClient
extends AbstractRegisteredClient {
    @Schema(name="\u5ba2\u6237\u7aefId", title="\u9ed8\u8ba4\u4e3a\u7cfb\u7edf\u81ea\u52a8\u751f\u6210")
    @Column(name="client_id", length=100)
    private String clientId = IdUtil.fastSimpleUUID();
    @Schema(name="\u5ba2\u6237\u7aef\u79d8\u94a5", title="\u8fd9\u91cc\u5b58\u50a8\u7684\u5ba2\u6237\u7aef\u79d8\u94a5\u662f\u660e\u6587\uff0c\u65b9\u4fbf\u4f7f\u7528\u3002\u9ed8\u8ba4\u4e3a\u7cfb\u7edf\u81ea\u52a8\u751f\u6210")
    @Column(name="client_secret", length=100)
    private String clientSecret = IdUtil.fastSimpleUUID();
    @Schema(name="\u662f\u5426\u9700\u8981\u8bc1\u660eKey", title="\u5982\u679c\u5ba2\u6237\u7aef\u5728\u6267\u884c\u6388\u6743\u7801\u6388\u4e88\u6d41\u65f6\u9700\u8981\u63d0\u4f9b\u9a8c\u8bc1\u5bc6\u94a5\u8d28\u8be2\u548c\u9a8c\u8bc1\u5668, \u9ed8\u8ba4False")
    @Column(name="require_proof_key")
    private Boolean requireProofKey = Boolean.FALSE;
    @Schema(name="\u662f\u5426\u9700\u8981\u8ba4\u8bc1\u786e\u8ba4", title="\u5982\u679c\u5ba2\u6237\u7aef\u5728\u6267\u884c\u6388\u6743\u7801\u6388\u4e88\u6d41\u65f6\u9700\u8981\u63d0\u4f9b\u9a8c\u8bc1\u5bc6\u94a5\u8d28\u8be2\u548c\u9a8c\u8bc1\u5668, \u9ed8\u8ba4False")
    @Column(name="require_authorization_consent")
    private Boolean requireAuthorizationConsent = Boolean.TRUE;
    @Schema(name="\u5ba2\u6237\u7aefJSON Web\u5bc6\u94a5\u96c6\u7684URL", title="\u5ba2\u6237\u7aefJSON Web\u5bc6\u94a5\u96c6\u7684URL")
    @Column(name="jwk_set_url", length=1000)
    private String jwkSetUrl;
    @Schema(name="JWT \u7b7e\u540d\u7b97\u6cd5", title="\u4ec5\u5728 clientAuthenticationMethods \u4e3a private_key_jwt \u548c client_secret_jwt \u65b9\u6cd5\u4e0b\u4f7f\u7528")
    @Column(name="signing_algorithm")
    @Enumerated(value=EnumType.ORDINAL)
    private AllJwsAlgorithm authenticationSigningAlgorithm;
    @Schema(name="\u6388\u6743\u7801\u6709\u6548\u65f6\u95f4", title="\u9ed8\u8ba45\u5206\u949f\uff0c\u4f7f\u7528 Duration \u65f6\u95f4\u683c\u5f0f")
    @Column(name="authorization_code_validity")
    private Duration authorizationCodeValidity = Duration.ofMinutes(5L);
    @Schema(name="\u6fc0\u6d3b\u7801\u6709\u6548\u65f6\u95f4", title="\u9ed8\u8ba45\u5206\u949f\uff0c\u4f7f\u7528 Duration \u65f6\u95f4\u683c\u5f0f")
    @Column(name="device_code_validity")
    private Duration deviceCodeValidity = Duration.ofMinutes(5L);
    @Schema(name="AccessToken \u6709\u6548\u65f6\u95f4", title="\u9ed8\u8ba45\u5206\u949f\uff0c\u4f7f\u7528 Duration \u65f6\u95f4\u683c\u5f0f")
    @Column(name="access_token_validity")
    private Duration accessTokenValidity = Duration.ofMinutes(5L);
    @Schema(name="RefreshToken \u6709\u6548\u65f6\u95f4", title="\u9ed8\u8ba460\u5206\u949f\uff0c\u4f7f\u7528 Duration \u65f6\u95f4\u683c\u5f0f")
    @Column(name="refresh_token_validity")
    private Duration refreshTokenValidity = Duration.ofMinutes(60L);
    @Schema(name="Access Token \u683c\u5f0f", title="OAuth 2.0\u4ee4\u724c\u7684\u6807\u51c6\u6570\u636e\u683c\u5f0f")
    @Column(name="access_token_format")
    @Enumerated(value=EnumType.ORDINAL)
    private TokenFormat accessTokenFormat = TokenFormat.REFERENCE;
    @Schema(name="\u662f\u5426\u91cd\u7528 Refresh Token", title="\u9ed8\u8ba4\u503c True")
    @Column(name="reuse_refresh_tokens")
    private Boolean reuseRefreshTokens = Boolean.TRUE;
    @Schema(name="IdToken \u7b7e\u540d\u7b97\u6cd5", title="JWT \u7b97\u6cd5\u7528\u4e8e\u7b7e\u540d ID Token\uff0c \u9ed8\u8ba4\u503c RS256")
    @Column(name="signature_algorithm")
    @Enumerated(value=EnumType.ORDINAL)
    private SignatureJwsAlgorithm idTokenSignatureAlgorithmJwsAlgorithm = SignatureJwsAlgorithm.RS256;

    public abstract Set<OAuth2Scope> getScopes();

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public Boolean getRequireProofKey() {
        return this.requireProofKey;
    }

    public void setRequireProofKey(Boolean requireProofKey) {
        this.requireProofKey = requireProofKey;
    }

    public Boolean getRequireAuthorizationConsent() {
        return this.requireAuthorizationConsent;
    }

    public void setRequireAuthorizationConsent(Boolean requireAuthorizationConsent) {
        this.requireAuthorizationConsent = requireAuthorizationConsent;
    }

    public String getJwkSetUrl() {
        return this.jwkSetUrl;
    }

    public void setJwkSetUrl(String jwkSetUrl) {
        this.jwkSetUrl = jwkSetUrl;
    }

    public AllJwsAlgorithm getAuthenticationSigningAlgorithm() {
        return this.authenticationSigningAlgorithm;
    }

    public void setAuthenticationSigningAlgorithm(AllJwsAlgorithm authenticationSigningAlgorithm) {
        this.authenticationSigningAlgorithm = authenticationSigningAlgorithm;
    }

    public Duration getAuthorizationCodeValidity() {
        return this.authorizationCodeValidity;
    }

    public void setAuthorizationCodeValidity(Duration authorizationCodeValidity) {
        this.authorizationCodeValidity = authorizationCodeValidity;
    }

    public Duration getAccessTokenValidity() {
        return this.accessTokenValidity;
    }

    public void setAccessTokenValidity(Duration accessTokenValidity) {
        this.accessTokenValidity = accessTokenValidity;
    }

    public Duration getDeviceCodeValidity() {
        return this.deviceCodeValidity;
    }

    public void setDeviceCodeValidity(Duration deviceCodeValidity) {
        this.deviceCodeValidity = deviceCodeValidity;
    }

    public Duration getRefreshTokenValidity() {
        return this.refreshTokenValidity;
    }

    public void setRefreshTokenValidity(Duration refreshTokenValidity) {
        this.refreshTokenValidity = refreshTokenValidity;
    }

    public TokenFormat getAccessTokenFormat() {
        return this.accessTokenFormat;
    }

    public void setAccessTokenFormat(TokenFormat accessTokenFormat) {
        this.accessTokenFormat = accessTokenFormat;
    }

    public Boolean getReuseRefreshTokens() {
        return this.reuseRefreshTokens;
    }

    public void setReuseRefreshTokens(Boolean reuseRefreshTokens) {
        this.reuseRefreshTokens = reuseRefreshTokens;
    }

    public SignatureJwsAlgorithm getIdTokenSignatureAlgorithm() {
        return this.idTokenSignatureAlgorithmJwsAlgorithm;
    }

    public void setIdTokenSignatureAlgorithm(SignatureJwsAlgorithm idTokenSignatureAlgorithmJwsAlgorithm) {
        this.idTokenSignatureAlgorithmJwsAlgorithm = idTokenSignatureAlgorithmJwsAlgorithm;
    }
}

