/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.compliance.listener;

import cn.herodotus.engine.cache.core.exception.MaximumLimitExceededException;
import cn.herodotus.engine.oauth2.authentication.stamp.SignInFailureLimitedStampManager;
import cn.herodotus.engine.oauth2.management.compliance.OAuth2AccountStatusManager;
import java.time.Duration;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationGrantAuthenticationToken;

public class AuthenticationFailureListener
implements ApplicationListener<AbstractAuthenticationFailureEvent> {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationFailureListener.class);
    private final SignInFailureLimitedStampManager stampManager;
    private final OAuth2AccountStatusManager accountStatusManager;

    public AuthenticationFailureListener(SignInFailureLimitedStampManager stampManager, OAuth2AccountStatusManager accountStatusManager) {
        this.stampManager = stampManager;
        this.accountStatusManager = accountStatusManager;
    }

    public void onApplicationEvent(AbstractAuthenticationFailureEvent event) {
        log.debug("[Herodotus] |- User sign in catch failure event : [{}].", (Object)event.getClass().getName());
        if (event instanceof AuthenticationFailureBadCredentialsEvent) {
            OAuth2AuthorizationGrantAuthenticationToken token;
            Authentication authentication = event.getAuthentication();
            String username = null;
            if (authentication instanceof OAuth2AuthorizationGrantAuthenticationToken) {
                log.debug("[Herodotus] |- Toke object in failure event  is OAuth2AuthorizationGrantAuthenticationToken");
                token = (OAuth2AuthorizationGrantAuthenticationToken)authentication;
                Map params = token.getAdditionalParameters();
                username = this.getPrincipal(params);
            }
            if (authentication instanceof UsernamePasswordAuthenticationToken) {
                log.debug("[Herodotus] |- Toke object in failure event  is UsernamePasswordAuthenticationToken");
                token = (UsernamePasswordAuthenticationToken)authentication;
                Object principal = token.getPrincipal();
                if (principal instanceof String) {
                    username = (String)principal;
                }
            }
            if (StringUtils.isNotBlank(username)) {
                log.debug("[Herodotus] |- Parse the user name in failure event is [{}].", username);
                int maxTimes = this.stampManager.getAuthenticationProperties().getSignInFailureLimited().getMaxTimes();
                Duration expire = this.stampManager.getAuthenticationProperties().getSignInFailureLimited().getExpire();
                try {
                    int times = this.stampManager.counting(username, maxTimes, expire, true, "AuthenticationFailureListener");
                    log.debug("[Herodotus] |- Sign in user input password error [{}] items", (Object)times);
                }
                catch (MaximumLimitExceededException e) {
                    log.warn("[Herodotus] |- User [{}] password error [{}] items, LOCK ACCOUNT!", (Object)username, (Object)maxTimes);
                    this.accountStatusManager.lock(username);
                }
            }
        }
    }

    private String getPrincipal(Map<String, Object> params) {
        Object value;
        if (MapUtils.isNotEmpty(params) && params.containsKey("username") && ObjectUtils.isNotEmpty((Object)(value = params.get("username")))) {
            return (String)value;
        }
        return null;
    }
}

