/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.service;

import cn.herodotus.engine.assistant.core.definition.domain.Entity;
import cn.herodotus.engine.data.core.repository.BaseRepository;
import cn.herodotus.engine.data.core.service.BaseService;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Permission;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Scope;
import cn.herodotus.engine.oauth2.management.repository.OAuth2ScopeRepository;
import java.io.Serializable;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OAuth2ScopeService
extends BaseService<OAuth2Scope, String> {
    private static final Logger log = LoggerFactory.getLogger(OAuth2ScopeService.class);
    private final OAuth2ScopeRepository oauthScopesRepository;

    @Autowired
    public OAuth2ScopeService(OAuth2ScopeRepository oauthScopesRepository) {
        this.oauthScopesRepository = oauthScopesRepository;
    }

    public BaseRepository<OAuth2Scope, String> getRepository() {
        return this.oauthScopesRepository;
    }

    public OAuth2Scope assigned(String scopeId, Set<OAuth2Permission> permissions) {
        OAuth2Scope oldScope = (OAuth2Scope)this.findById((Serializable)((Object)scopeId));
        oldScope.setPermissions(permissions);
        OAuth2Scope newScope = (OAuth2Scope)this.saveOrUpdate((Entity)oldScope);
        log.debug("[Herodotus] |- OAuth2ScopeService assign.");
        return newScope;
    }

    public OAuth2Scope findByScopeCode(String scopeCode) {
        OAuth2Scope scope = this.oauthScopesRepository.findByScopeCode(scopeCode);
        log.debug("[Herodotus] |- OAuth2ScopeService findByScopeCode.");
        return scope;
    }
}

