/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.dto;

import cn.herodotus.engine.assistant.core.json.jackson2.deserializer.ArrayOrStringDeserializer;
import cn.herodotus.engine.oauth2.core.enums.ApplicationType;
import cn.herodotus.engine.oauth2.core.enums.Signature;
import cn.herodotus.engine.oauth2.core.enums.TokenFormat;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Scope;
import cn.herodotus.engine.rest.core.definition.dto.BaseSysDto;
import cn.hutool.core.util.IdUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jsr310.deser.DurationDeserializer;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Set;

public class OAuth2ApplicationDto
extends BaseSysDto {
    @Schema(name="\u5e94\u7528ID")
    private String applicationId;
    @Schema(name="\u5e94\u7528\u540d\u79f0", required=true)
    @NotBlank(message="\u5e94\u7528\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u5e94\u7528\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String applicationName;
    @Schema(name="\u5e94\u7528\u7b80\u79f0", title="\u5e94\u7528\u7684\u7b80\u79f0\u3001\u522b\u540d\u3001\u7f29\u5199\u7b49\u4fe1\u606f")
    private String abbreviation;
    @Schema(name="Logo", title="Logo\u5b58\u50a8\u4fe1\u606f\uff0c\u53ef\u4ee5\u662fURL\u6216\u8005\u8def\u5f84\u7b49")
    private String logo;
    @Schema(name="\u4e3b\u9875\u4fe1\u606f", title="\u5e94\u7528\u76f8\u5173\u7684\u4e3b\u9875\u4fe1\u606f\u65b9\u4fbf\u67e5\u8be2")
    private String homepage;
    @Schema(name="\u5e94\u7528\u7c7b\u578b", title="\u7528\u4e8e\u533a\u5206\u4e0d\u540c\u7c7b\u578b\u7684\u5e94\u7528")
    private ApplicationType applicationType = ApplicationType.WEB;
    @Schema(name="\u5ba2\u6237\u7aefId", title="\u9ed8\u8ba4\u4e3a\u7cfb\u7edf\u81ea\u52a8\u751f\u6210")
    private String clientId = IdUtil.fastSimpleUUID();
    @Schema(name="\u5ba2\u6237\u7aefID\u53d1\u5e03\u65e5\u671f", title="\u5ba2\u6237\u7aef\u53d1\u5e03\u65e5\u671f")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale="GMT+8", shape=JsonFormat.Shape.STRING)
    private LocalDateTime clientIdIssuedAt;
    @Schema(name="\u5ba2\u6237\u7aef\u79d8\u94a5", title="\u8fd9\u91cc\u5b58\u50a8\u7684\u5ba2\u6237\u7aef\u79d8\u94a5\u662f\u660e\u6587\uff0c\u65b9\u4fbf\u4f7f\u7528\u3002\u9ed8\u8ba4\u4e3a\u7cfb\u7edf\u81ea\u52a8\u751f\u6210")
    private String clientSecret = IdUtil.fastSimpleUUID();
    @Schema(name="\u5ba2\u6237\u7aef\u79d8\u94a5\u8fc7\u671f\u65f6\u95f4", title="\u5ba2\u6237\u7aef\u79d8\u94a5\u8fc7\u671f\u65f6\u95f4")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale="GMT+8", shape=JsonFormat.Shape.STRING)
    private LocalDateTime clientSecretExpiresAt;
    @Schema(name="\u5ba2\u6237\u7aef\u8ba4\u8bc1\u6a21\u5f0f", title="\u652f\u6301\u591a\u4e2a\u503c\uff0c\u4ee5\u9017\u53f7\u5206\u9694", required=true)
    @JsonDeserialize(using=ArrayOrStringDeserializer.class)
    private Set<String> clientAuthenticationMethods = Collections.emptySet();
    @Schema(name="\u8ba4\u8bc1\u6a21\u5f0f", title="\u652f\u6301\u591a\u4e2a\u503c\uff0c\u4ee5\u9017\u53f7\u5206\u9694", required=true)
    @JsonDeserialize(using=ArrayOrStringDeserializer.class)
    private Set<String> authorizationGrantTypes = Collections.emptySet();
    @Schema(name="\u56de\u8c03\u5730\u5740", title="\u652f\u6301\u591a\u4e2a\u503c\uff0c\u4ee5\u9017\u53f7\u5206\u9694")
    private String redirectUris;
    @Schema(name="OIDC Logout \u56de\u8c03\u5730\u5740", title="\u652f\u6301\u591a\u4e2a\u503c\uff0c\u4ee5\u9017\u53f7\u5206\u9694")
    private String postLogoutRedirectUris;
    @Schema(name="\u9700\u8981\u8bc1\u660eKey", title="\u5982\u679c\u5ba2\u6237\u7aef\u5728\u6267\u884c\u6388\u6743\u7801\u6388\u4e88\u6d41\u65f6\u9700\u8981\u63d0\u4f9b\u9a8c\u8bc1\u5bc6\u94a5\u8d28\u8be2\u548c\u9a8c\u8bc1\u5668, \u9ed8\u8ba4False")
    private Boolean requireProofKey = Boolean.FALSE;
    @Schema(name="\u9700\u8981\u8ba4\u8bc1\u786e\u8ba4", title="\u5982\u679c\u5ba2\u6237\u7aef\u5728\u6267\u884c\u6388\u6743\u7801\u6388\u4e88\u6d41\u65f6\u9700\u8981\u63d0\u4f9b\u9a8c\u8bc1\u5bc6\u94a5\u8d28\u8be2\u548c\u9a8c\u8bc1\u5668, \u9ed8\u8ba4False")
    private Boolean requireAuthorizationConsent = Boolean.TRUE;
    @Schema(name="\u5ba2\u6237\u7aefJSON Web\u5bc6\u94a5\u96c6\u7684URL", title="\u5ba2\u6237\u7aefJSON Web\u5bc6\u94a5\u96c6\u7684URL")
    private String jwkSetUrl;
    @Schema(name="JWT \u7b7e\u540d\u7b97\u6cd5", title="\u4ec5\u5728 clientAuthenticationMethods \u4e3a private_key_jwt \u548c client_secret_jwt \u65b9\u6cd5\u4e0b\u4f7f\u7528")
    private Signature authenticationSigningAlgorithm;
    @Schema(name="\u6388\u6743\u7801\u6709\u6548\u65f6\u95f4", title="\u9ed8\u8ba45\u5206\u949f\uff0c\u4f7f\u7528 Duration \u65f6\u95f4\u683c\u5f0f")
    @JsonDeserialize(using=DurationDeserializer.class)
    private Duration authorizationCodeValidity = Duration.ofSeconds(5L);
    @Schema(name="accessToken \u6709\u6548\u65f6\u95f4", title="\u9ed8\u8ba45\u5206\u949f\uff0c\u4f7f\u7528 Duration \u65f6\u95f4\u683c\u5f0f")
    @JsonDeserialize(using=DurationDeserializer.class)
    private Duration accessTokenValidity = Duration.ofSeconds(5L);
    @Schema(name="\u6fc0\u6d3b\u7801\u6709\u6548\u65f6\u95f4", title="\u9ed8\u8ba45\u5206\u949f\uff0c\u4f7f\u7528 Duration \u65f6\u95f4\u683c\u5f0f")
    @JsonDeserialize(using=DurationDeserializer.class)
    private Duration deviceCodeValidity = Duration.ofSeconds(5L);
    @Schema(name="refreshToken \u6709\u6548\u65f6\u95f4", title="\u9ed8\u8ba460\u5206\u949f\uff0c\u4f7f\u7528 Duration \u65f6\u95f4\u683c\u5f0f")
    @JsonDeserialize(using=DurationDeserializer.class)
    private Duration refreshTokenValidity = Duration.ofHours(1L);
    @Schema(name="Access Token \u683c\u5f0f", title="OAuth 2.0\u4ee4\u724c\u7684\u6807\u51c6\u6570\u636e\u683c\u5f0f")
    private TokenFormat accessTokenFormat = TokenFormat.SELF_CONTAINED;
    @Schema(name="\u662f\u5426\u91cd\u7528 Refresh Token", title="\u9ed8\u8ba4\u503c True")
    private Boolean reuseRefreshTokens = Boolean.TRUE;
    @Schema(name="IdToken \u7b7e\u540d\u7b97\u6cd5", title="JWT \u7b97\u6cd5\u7528\u4e8e\u7b7e\u540d ID Token\uff0c \u9ed8\u8ba4\u503c RS256")
    private Signature idTokenSignatureAlgorithm = Signature.RS256;
    @Schema(name="\u5e94\u7528\u5bf9\u5e94Scope", title="\u4f20\u9012\u5e94\u7528\u5bf9\u5e94Scope ID")
    private Set<OAuth2Scope> scopes = Collections.emptySet();

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public LocalDateTime getClientIdIssuedAt() {
        return this.clientIdIssuedAt;
    }

    public void setClientIdIssuedAt(LocalDateTime clientIdIssuedAt) {
        this.clientIdIssuedAt = clientIdIssuedAt;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public LocalDateTime getClientSecretExpiresAt() {
        return this.clientSecretExpiresAt;
    }

    public void setClientSecretExpiresAt(LocalDateTime clientSecretExpiresAt) {
        this.clientSecretExpiresAt = clientSecretExpiresAt;
    }

    public Set<String> getClientAuthenticationMethods() {
        return this.clientAuthenticationMethods;
    }

    public void setClientAuthenticationMethods(Set<String> clientAuthenticationMethods) {
        this.clientAuthenticationMethods = clientAuthenticationMethods;
    }

    public Set<String> getAuthorizationGrantTypes() {
        return this.authorizationGrantTypes;
    }

    public void setAuthorizationGrantTypes(Set<String> authorizationGrantTypes) {
        this.authorizationGrantTypes = authorizationGrantTypes;
    }

    public String getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(String redirectUris) {
        this.redirectUris = redirectUris;
    }

    public String getPostLogoutRedirectUris() {
        return this.postLogoutRedirectUris;
    }

    public void setPostLogoutRedirectUris(String postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
    }

    public Boolean getRequireProofKey() {
        return this.requireProofKey;
    }

    public void setRequireProofKey(Boolean requireProofKey) {
        this.requireProofKey = requireProofKey;
    }

    public Boolean getRequireAuthorizationConsent() {
        return this.requireAuthorizationConsent;
    }

    public void setRequireAuthorizationConsent(Boolean requireAuthorizationConsent) {
        this.requireAuthorizationConsent = requireAuthorizationConsent;
    }

    public String getJwkSetUrl() {
        return this.jwkSetUrl;
    }

    public void setJwkSetUrl(String jwkSetUrl) {
        this.jwkSetUrl = jwkSetUrl;
    }

    public Signature getAuthenticationSigningAlgorithm() {
        return this.authenticationSigningAlgorithm;
    }

    public void setAuthenticationSigningAlgorithm(Signature authenticationSigningAlgorithm) {
        this.authenticationSigningAlgorithm = authenticationSigningAlgorithm;
    }

    public Duration getAuthorizationCodeValidity() {
        return this.authorizationCodeValidity;
    }

    public void setAuthorizationCodeValidity(Duration authorizationCodeValidity) {
        this.authorizationCodeValidity = authorizationCodeValidity;
    }

    public Duration getAccessTokenValidity() {
        return this.accessTokenValidity;
    }

    public void setAccessTokenValidity(Duration accessTokenValidity) {
        this.accessTokenValidity = accessTokenValidity;
    }

    public Duration getDeviceCodeValidity() {
        return this.deviceCodeValidity;
    }

    public void setDeviceCodeValidity(Duration deviceCodeValidity) {
        this.deviceCodeValidity = deviceCodeValidity;
    }

    public Duration getRefreshTokenValidity() {
        return this.refreshTokenValidity;
    }

    public void setRefreshTokenValidity(Duration refreshTokenValidity) {
        this.refreshTokenValidity = refreshTokenValidity;
    }

    public TokenFormat getAccessTokenFormat() {
        return this.accessTokenFormat;
    }

    public void setAccessTokenFormat(TokenFormat accessTokenFormat) {
        this.accessTokenFormat = accessTokenFormat;
    }

    public Boolean getReuseRefreshTokens() {
        return this.reuseRefreshTokens;
    }

    public void setReuseRefreshTokens(Boolean reuseRefreshTokens) {
        this.reuseRefreshTokens = reuseRefreshTokens;
    }

    public Signature getIdTokenSignatureAlgorithm() {
        return this.idTokenSignatureAlgorithm;
    }

    public void setIdTokenSignatureAlgorithm(Signature idTokenSignatureAlgorithm) {
        this.idTokenSignatureAlgorithm = idTokenSignatureAlgorithm;
    }

    public Set<OAuth2Scope> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<OAuth2Scope> scopes) {
        this.scopes = scopes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("applicationId", (Object)this.applicationId).add("applicationName", (Object)this.applicationName).add("abbreviation", (Object)this.abbreviation).add("logo", (Object)this.logo).add("homepage", (Object)this.homepage).add("applicationType", (Object)this.applicationType).add("clientId", (Object)this.clientId).add("clientIdIssuedAt", (Object)this.clientIdIssuedAt).add("clientSecret", (Object)this.clientSecret).add("clientSecretExpiresAt", (Object)this.clientSecretExpiresAt).add("clientAuthenticationMethods", this.clientAuthenticationMethods).add("authorizationGrantTypes", this.authorizationGrantTypes).add("redirectUris", (Object)this.redirectUris).add("postLogoutRedirectUris", (Object)this.postLogoutRedirectUris).add("requireProofKey", (Object)this.requireProofKey).add("requireAuthorizationConsent", (Object)this.requireAuthorizationConsent).add("jwkSetUrl", (Object)this.jwkSetUrl).add("authenticationSigningAlgorithm", (Object)this.authenticationSigningAlgorithm).add("authorizationCodeValidity", (Object)this.authorizationCodeValidity).add("accessTokenValidity", (Object)this.accessTokenValidity).add("deviceCodeValidity", (Object)this.deviceCodeValidity).add("refreshTokenValidity", (Object)this.refreshTokenValidity).add("accessTokenFormat", (Object)this.accessTokenFormat).add("reuseRefreshTokens", (Object)this.reuseRefreshTokens).add("idTokenSignatureAlgorithm", (Object)this.idTokenSignatureAlgorithm).toString();
    }
}

