/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.entity;

import cn.herodotus.engine.data.core.entity.BaseSysEntity;
import cn.herodotus.engine.oauth2.core.definition.domain.RegisteredClientDetails;
import cn.herodotus.engine.oauth2.core.enums.ApplicationType;
import cn.herodotus.engine.oauth2.core.enums.Signature;
import cn.herodotus.engine.oauth2.core.enums.TokenFormat;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Scope;
import cn.hutool.core.util.IdUtil;
import com.google.common.base.MoreObjects;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.UuidGenerator;

@Entity
@Table(name="oauth2_application", indexes={@Index(name="oauth2_application_id_idx", columnList="application_id"), @Index(name="oauth2_application_cid_idx", columnList="client_id")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:oauth2:application")
public class OAuth2Application
extends BaseSysEntity
implements RegisteredClientDetails {
    @Id
    @UuidGenerator
    @Column(name="application_id", length=64)
    private String applicationId;
    @Column(name="application_name", length=128)
    private String applicationName;
    @Column(name="abbreviation", length=64)
    private String abbreviation;
    @Column(name="logo", length=1024)
    private String logo;
    @Column(name="homepage", length=1024)
    private String homepage;
    @Column(name="application_type")
    @Enumerated(value=EnumType.ORDINAL)
    private ApplicationType applicationType = ApplicationType.WEB;
    @Column(name="client_id", length=100)
    private String clientId = IdUtil.fastSimpleUUID();
    @Column(name="client_id_issued_at")
    @CreationTimestamp
    private LocalDateTime clientIdIssuedAt;
    @Column(name="client_secret", length=100)
    private String clientSecret = IdUtil.fastSimpleUUID();
    @Column(name="client_secret_expires_at")
    private LocalDateTime clientSecretExpiresAt;
    @Column(name="client_authentication_methods", length=1000)
    private String clientAuthenticationMethods;
    @Column(name="authorization_grant_types", length=1000)
    private String authorizationGrantTypes;
    @Column(name="redirect_uris", length=1000)
    private String redirectUris;
    @Column(name="post_logout_redirect_uris", length=1000)
    private String postLogoutRedirectUris;
    @Column(name="require_proof_key")
    private Boolean requireProofKey = Boolean.FALSE;
    @Column(name="require_authorization_consent")
    private Boolean requireAuthorizationConsent = Boolean.TRUE;
    @Column(name="jwk_set_url", length=1000)
    private String jwkSetUrl;
    @Column(name="signing_algorithm")
    @Enumerated(value=EnumType.ORDINAL)
    private Signature authenticationSigningAlgorithm;
    @Column(name="authorization_code_validity")
    private Duration authorizationCodeValidity = Duration.ofMinutes(5L);
    @Column(name="access_token_validity")
    private Duration accessTokenValidity = Duration.ofMinutes(5L);
    @Column(name="device_code_validity")
    private Duration deviceCodeValidity = Duration.ofMinutes(5L);
    @Column(name="refresh_token_validity")
    private Duration refreshTokenValidity = Duration.ofMinutes(60L);
    @Column(name="access_token_format")
    @Enumerated(value=EnumType.ORDINAL)
    private TokenFormat accessTokenFormat = TokenFormat.REFERENCE;
    @Column(name="reuse_refresh_tokens")
    private Boolean reuseRefreshTokens = Boolean.TRUE;
    @Column(name="signature_algorithm")
    @Enumerated(value=EnumType.ORDINAL)
    private Signature idTokenSignatureAlgorithm = Signature.RS256;
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:oauth2:application:scope")
    @ManyToMany(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SUBSELECT)
    @JoinTable(name="oauth2_application_scope", joinColumns={@JoinColumn(name="application_id")}, inverseJoinColumns={@JoinColumn(name="scope_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"application_id", "scope_id"})}, indexes={@Index(name="oauth2_application_scope_aid_idx", columnList="application_id"), @Index(name="oauth2_application_scope_sid_idx", columnList="scope_id")})
    private Set<OAuth2Scope> scopes = new HashSet<OAuth2Scope>();

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public String getId() {
        return this.getApplicationId();
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public LocalDateTime getClientIdIssuedAt() {
        return this.clientIdIssuedAt;
    }

    public void setClientIdIssuedAt(LocalDateTime clientIdIssuedAt) {
        this.clientIdIssuedAt = clientIdIssuedAt;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public LocalDateTime getClientSecretExpiresAt() {
        return this.clientSecretExpiresAt;
    }

    public String getClientName() {
        return this.getApplicationId();
    }

    public void setClientSecretExpiresAt(LocalDateTime clientSecretExpiresAt) {
        this.clientSecretExpiresAt = clientSecretExpiresAt;
    }

    public String getClientAuthenticationMethods() {
        return this.clientAuthenticationMethods;
    }

    public void setClientAuthenticationMethods(String clientAuthenticationMethods) {
        this.clientAuthenticationMethods = clientAuthenticationMethods;
    }

    public String getAuthorizationGrantTypes() {
        return this.authorizationGrantTypes;
    }

    public void setAuthorizationGrantTypes(String authorizationGrantTypes) {
        this.authorizationGrantTypes = authorizationGrantTypes;
    }

    public String getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(String redirectUris) {
        this.redirectUris = redirectUris;
    }

    public String getPostLogoutRedirectUris() {
        return this.postLogoutRedirectUris;
    }

    public void setPostLogoutRedirectUris(String postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
    }

    public Boolean getRequireProofKey() {
        return this.requireProofKey;
    }

    public void setRequireProofKey(Boolean requireProofKey) {
        this.requireProofKey = requireProofKey;
    }

    public Boolean getRequireAuthorizationConsent() {
        return this.requireAuthorizationConsent;
    }

    public void setRequireAuthorizationConsent(Boolean requireAuthorizationConsent) {
        this.requireAuthorizationConsent = requireAuthorizationConsent;
    }

    public String getJwkSetUrl() {
        return this.jwkSetUrl;
    }

    public void setJwkSetUrl(String jwkSetUrl) {
        this.jwkSetUrl = jwkSetUrl;
    }

    public Signature getAuthenticationSigningAlgorithm() {
        return this.authenticationSigningAlgorithm;
    }

    public void setAuthenticationSigningAlgorithm(Signature authenticationSigningAlgorithm) {
        this.authenticationSigningAlgorithm = authenticationSigningAlgorithm;
    }

    public Duration getAuthorizationCodeValidity() {
        return this.authorizationCodeValidity;
    }

    public void setAuthorizationCodeValidity(Duration authorizationCodeValidity) {
        this.authorizationCodeValidity = authorizationCodeValidity;
    }

    public Duration getAccessTokenValidity() {
        return this.accessTokenValidity;
    }

    public void setAccessTokenValidity(Duration accessTokenValidity) {
        this.accessTokenValidity = accessTokenValidity;
    }

    public Duration getDeviceCodeValidity() {
        return this.deviceCodeValidity;
    }

    public void setDeviceCodeValidity(Duration deviceCodeValidity) {
        this.deviceCodeValidity = deviceCodeValidity;
    }

    public Duration getRefreshTokenValidity() {
        return this.refreshTokenValidity;
    }

    public void setRefreshTokenValidity(Duration refreshTokenValidity) {
        this.refreshTokenValidity = refreshTokenValidity;
    }

    public TokenFormat getAccessTokenFormat() {
        return this.accessTokenFormat;
    }

    public void setAccessTokenFormat(TokenFormat accessTokenFormat) {
        this.accessTokenFormat = accessTokenFormat;
    }

    public Boolean getReuseRefreshTokens() {
        return this.reuseRefreshTokens;
    }

    public void setReuseRefreshTokens(Boolean reuseRefreshTokens) {
        this.reuseRefreshTokens = reuseRefreshTokens;
    }

    public Signature getIdTokenSignatureAlgorithm() {
        return this.idTokenSignatureAlgorithm;
    }

    public void setIdTokenSignatureAlgorithm(Signature idTokenSignatureAlgorithm) {
        this.idTokenSignatureAlgorithm = idTokenSignatureAlgorithm;
    }

    public Set<OAuth2Scope> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<OAuth2Scope> scopes) {
        this.scopes = scopes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("applicationId", (Object)this.applicationId).add("applicationName", (Object)this.applicationName).add("abbreviation", (Object)this.abbreviation).add("logo", (Object)this.logo).add("homepage", (Object)this.homepage).add("applicationType", (Object)this.applicationType).add("clientId", (Object)this.clientId).add("clientIdIssuedAt", (Object)this.clientIdIssuedAt).add("clientSecret", (Object)this.clientSecret).add("clientSecretExpiresAt", (Object)this.clientSecretExpiresAt).add("clientAuthenticationMethods", (Object)this.clientAuthenticationMethods).add("authorizationGrantTypes", (Object)this.authorizationGrantTypes).add("redirectUris", (Object)this.redirectUris).add("postLogoutRedirectUris", (Object)this.postLogoutRedirectUris).add("requireProofKey", (Object)this.requireProofKey).add("requireAuthorizationConsent", (Object)this.requireAuthorizationConsent).add("jwkSetUrl", (Object)this.jwkSetUrl).add("authenticationSigningAlgorithm", (Object)this.authenticationSigningAlgorithm).add("authorizationCodeValidity", (Object)this.authorizationCodeValidity).add("accessTokenValidity", (Object)this.accessTokenValidity).add("deviceCodeValidity", (Object)this.deviceCodeValidity).add("refreshTokenValidity", (Object)this.refreshTokenValidity).add("accessTokenFormat", (Object)this.accessTokenFormat).add("reuseRefreshTokens", (Object)this.reuseRefreshTokens).add("idTokenSignatureAlgorithm", (Object)this.idTokenSignatureAlgorithm).add("scopes", this.scopes).toString();
    }
}

