/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.controller;

import cn.herodotus.engine.assistant.core.definition.domain.Entity;
import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.data.core.service.WriteableService;
import cn.herodotus.engine.oauth2.management.dto.OAuth2ApplicationDto;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Application;
import cn.herodotus.engine.oauth2.management.service.OAuth2ApplicationService;
import cn.herodotus.engine.rest.core.controller.BaseController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/authorize/application"})
@Tags(value={@Tag(name="OAuth2 \u8ba4\u8bc1\u670d\u52a1\u63a5\u53e3"), @Tag(name="OAuth2 \u5e94\u7528\u7ba1\u7406\u63a5\u53e3")})
public class OAuth2ApplicationController
extends BaseController<OAuth2Application, String> {
    private final OAuth2ApplicationService applicationService;

    @Autowired
    public OAuth2ApplicationController(OAuth2ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    public WriteableService<OAuth2Application, String> getWriteableService() {
        return this.applicationService;
    }

    @Operation(summary="\u83b7\u53d6OAuth2Application\u5206\u9875\u6570\u636e", description="\u901a\u8fc7pageNumber\u548cpageSize\u83b7\u53d6\u5206\u9875\u6570\u636e")
    @Parameters(value={@Parameter(name="pageNumber", required=true, description="\u5f53\u524d\u9875\u6570"), @Parameter(name="pageSize", required=true, description="\u6bcf\u9875\u663e\u793a\u6570\u636e\u6761\u76ee")})
    @GetMapping
    public Result<Map<String, Object>> findByPage(@RequestParam(value="pageNumber") Integer pageNumber, @RequestParam(value="pageSize") Integer pageSize) {
        Page pages = this.applicationService.findByPage(pageNumber, pageSize);
        if (ObjectUtils.isNotEmpty((Object)pages) && CollectionUtils.isNotEmpty((Collection)pages.getContent())) {
            List auth2Applications = pages.getContent().stream().map(this::toDto).collect(Collectors.toList());
            return this.result(this.getPageInfoMap(auth2Applications, pages.getTotalPages(), pages.getTotalElements()));
        }
        return Result.failure((String)"\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff01");
    }

    @Operation(summary="\u4fdd\u5b58\u6216\u66f4\u65b0OAuth2\u5e94\u7528", description="\u63a5\u6536JSON\u6570\u636e\uff0c\u8f6c\u6362\u4e3aOauthClientDetails\u5b9e\u4f53\uff0c\u8fdb\u884c\u66f4\u65b0")
    @Parameters(value={@Parameter(name="oauthClientDetails", required=true, description="\u53ef\u8f6c\u6362\u4e3aOauthClientDetails\u5b9e\u4f53\u7684json\u6570\u636e")})
    @PostMapping
    public Result<OAuth2Application> saveOrUpdate(@RequestBody OAuth2ApplicationDto domain) {
        OAuth2Application oAuth2Application = this.applicationService.saveOrUpdate(this.toEntity(domain));
        return this.result((Entity)oAuth2Application);
    }

    @Operation(summary="\u5220\u9664OAuth2\u5e94\u7528", description="\u6839\u636e\u5e94\u7528ID\u5220\u9664OAuth2\u5e94\u7528\uff0c\u4ee5\u53ca\u76f8\u5173\u8054\u7684\u5173\u7cfb\u6570\u636e")
    @Parameters(value={@Parameter(name="applicationId", required=true, description="applicationId")})
    @DeleteMapping
    public Result<String> delete(@RequestBody String applicationId) {
        this.applicationService.deleteById(applicationId);
        return Result.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Operation(summary="\u7ed9\u5e94\u7528\u5206\u914dScope", description="\u7ed9\u5e94\u7528\u5206\u914dScope")
    @Parameters(value={@Parameter(name="appKey", required=true, description="appKey"), @Parameter(name="scopes[]", required=true, description="Scope\u5bf9\u8c61\u7ec4\u6210\u7684\u6570\u7ec4")})
    @PutMapping
    public Result<OAuth2Application> authorize(@RequestParam(name="applicationId") String scopeId, @RequestParam(name="scopes[]") String[] scopes) {
        OAuth2Application application = this.applicationService.authorize(scopeId, scopes);
        return this.result((Entity)application);
    }

    private OAuth2ApplicationDto toDto(OAuth2Application entity) {
        OAuth2ApplicationDto dto = new OAuth2ApplicationDto();
        dto.setApplicationId(entity.getApplicationId());
        dto.setApplicationName(entity.getApplicationName());
        dto.setAbbreviation(entity.getAbbreviation());
        dto.setLogo(entity.getLogo());
        dto.setHomepage(entity.getHomepage());
        dto.setApplicationType(entity.getApplicationType());
        dto.setClientId(entity.getClientId());
        dto.setClientIdIssuedAt(entity.getClientIdIssuedAt());
        dto.setClientSecret(entity.getClientSecret());
        dto.setClientSecretExpiresAt(entity.getClientSecretExpiresAt());
        dto.setClientAuthenticationMethods(StringUtils.commaDelimitedListToSet((String)entity.getClientAuthenticationMethods()));
        dto.setAuthorizationGrantTypes(StringUtils.commaDelimitedListToSet((String)entity.getAuthorizationGrantTypes()));
        dto.setRedirectUris(entity.getRedirectUris());
        dto.setPostLogoutRedirectUris(entity.getPostLogoutRedirectUris());
        dto.setRequireProofKey(entity.getRequireProofKey());
        dto.setRequireAuthorizationConsent(entity.getRequireAuthorizationConsent());
        dto.setJwkSetUrl(entity.getJwkSetUrl());
        dto.setAuthenticationSigningAlgorithm(entity.getAuthenticationSigningAlgorithm());
        dto.setAccessTokenValidity(entity.getAccessTokenValidity());
        dto.setAuthorizationCodeValidity(entity.getAuthorizationCodeValidity());
        dto.setDeviceCodeValidity(entity.getDeviceCodeValidity());
        dto.setReuseRefreshTokens(entity.getReuseRefreshTokens());
        dto.setAccessTokenFormat(entity.getAccessTokenFormat());
        dto.setRefreshTokenValidity(entity.getRefreshTokenValidity());
        dto.setIdTokenSignatureAlgorithm(entity.getIdTokenSignatureAlgorithm());
        dto.setScopes(entity.getScopes());
        dto.setReserved(entity.getReserved());
        dto.setDescription(entity.getDescription());
        dto.setReversion(entity.getReversion());
        dto.setRanking(entity.getRanking());
        dto.setStatus(entity.getStatus());
        return dto;
    }

    public OAuth2Application toEntity(OAuth2ApplicationDto dto) {
        OAuth2Application entity = new OAuth2Application();
        entity.setApplicationId(dto.getApplicationId());
        entity.setApplicationName(dto.getApplicationName());
        entity.setAbbreviation(dto.getAbbreviation());
        entity.setLogo(dto.getLogo());
        entity.setHomepage(dto.getHomepage());
        entity.setApplicationType(dto.getApplicationType());
        entity.setClientId(dto.getClientId());
        entity.setClientIdIssuedAt(dto.getClientIdIssuedAt());
        entity.setClientSecret(dto.getClientSecret());
        entity.setClientSecretExpiresAt(dto.getClientSecretExpiresAt());
        entity.setClientAuthenticationMethods(StringUtils.collectionToCommaDelimitedString(dto.getClientAuthenticationMethods()));
        entity.setAuthorizationGrantTypes(StringUtils.collectionToCommaDelimitedString(dto.getAuthorizationGrantTypes()));
        entity.setRedirectUris(dto.getRedirectUris());
        entity.setPostLogoutRedirectUris(dto.getPostLogoutRedirectUris());
        entity.setRequireProofKey(dto.getRequireProofKey());
        entity.setRequireAuthorizationConsent(dto.getRequireAuthorizationConsent());
        entity.setJwkSetUrl(dto.getJwkSetUrl());
        entity.setAuthenticationSigningAlgorithm(dto.getAuthenticationSigningAlgorithm());
        entity.setAccessTokenValidity(dto.getAccessTokenValidity());
        entity.setAuthorizationCodeValidity(dto.getAuthorizationCodeValidity());
        entity.setRefreshTokenValidity(dto.getRefreshTokenValidity());
        entity.setDeviceCodeValidity(dto.getDeviceCodeValidity());
        entity.setReuseRefreshTokens(dto.getReuseRefreshTokens());
        entity.setIdTokenSignatureAlgorithm(dto.getIdTokenSignatureAlgorithm());
        entity.setAccessTokenFormat(dto.getAccessTokenFormat());
        entity.setIdTokenSignatureAlgorithm(dto.getIdTokenSignatureAlgorithm());
        entity.setScopes(dto.getScopes());
        entity.setReserved(dto.getReserved());
        entity.setDescription(dto.getDescription());
        entity.setReversion(dto.getReversion());
        entity.setRanking(dto.getRanking());
        entity.setStatus(dto.getStatus());
        return entity;
    }
}

