/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.management.adapter;

import cn.herodotus.engine.oauth2.data.jpa.definition.AbstractRegisteredClientAdapter;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Application;
import cn.herodotus.engine.oauth2.management.entity.OAuth2Scope;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.OAuth2TokenFormat;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;
import org.springframework.util.StringUtils;

public class OAuth2ApplicationRegisteredClientAdapter
extends AbstractRegisteredClientAdapter<OAuth2Application> {
    public Set<String> getScopes(OAuth2Application details) {
        Set<OAuth2Scope> clientScopes = details.getScopes();
        return clientScopes.stream().map(OAuth2Scope::getScopeCode).collect(Collectors.toSet());
    }

    public ClientSettings getClientSettings(OAuth2Application details) {
        SignatureAlgorithm jwsAlgorithm;
        ClientSettings.Builder clientSettingsBuilder = ClientSettings.builder();
        clientSettingsBuilder.requireAuthorizationConsent(details.getRequireAuthorizationConsent().booleanValue());
        clientSettingsBuilder.requireProofKey(details.getRequireProofKey().booleanValue());
        if (StringUtils.hasText((String)details.getJwkSetUrl())) {
            clientSettingsBuilder.jwkSetUrl(details.getJwkSetUrl());
        }
        if (ObjectUtils.isNotEmpty((Object)details.getAuthenticationSigningAlgorithm()) && ObjectUtils.isNotEmpty((Object)(jwsAlgorithm = SignatureAlgorithm.from((String)details.getAuthenticationSigningAlgorithm().name())))) {
            clientSettingsBuilder.tokenEndpointAuthenticationSigningAlgorithm((JwsAlgorithm)jwsAlgorithm);
        }
        return clientSettingsBuilder.build();
    }

    public TokenSettings getTokenSettings(OAuth2Application details) {
        SignatureAlgorithm signatureAlgorithm;
        TokenSettings.Builder tokenSettingsBuilder = TokenSettings.builder();
        tokenSettingsBuilder.authorizationCodeTimeToLive(details.getAuthorizationCodeValidity());
        tokenSettingsBuilder.deviceCodeTimeToLive(details.getDeviceCodeValidity());
        tokenSettingsBuilder.accessTokenTimeToLive(details.getAccessTokenValidity());
        tokenSettingsBuilder.refreshTokenTimeToLive(details.getRefreshTokenValidity());
        tokenSettingsBuilder.reuseRefreshTokens(details.getReuseRefreshTokens().booleanValue());
        tokenSettingsBuilder.accessTokenFormat(new OAuth2TokenFormat(details.getAccessTokenFormat().getFormat()));
        if (ObjectUtils.isNotEmpty((Object)details.getIdTokenSignatureAlgorithm()) && ObjectUtils.isNotEmpty((Object)(signatureAlgorithm = SignatureAlgorithm.from((String)details.getIdTokenSignatureAlgorithm().name())))) {
            tokenSettingsBuilder.idTokenSignatureAlgorithm(signatureAlgorithm);
        }
        return tokenSettingsBuilder.build();
    }
}

