/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.data.jpa.converter;

import cn.herodotus.engine.oauth2.data.jpa.definition.converter.AbstractOAuth2EntityConverter;
import cn.herodotus.engine.oauth2.data.jpa.entity.HerodotusRegisteredClient;
import cn.herodotus.engine.oauth2.data.jpa.jackson2.OAuth2JacksonProcessor;
import cn.hutool.v7.core.date.DateUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.util.StringUtils;

public class OAuth2ToHerodotusRegisteredClientConverter
extends AbstractOAuth2EntityConverter<RegisteredClient, HerodotusRegisteredClient> {
    private final PasswordEncoder passwordEncoder;

    public OAuth2ToHerodotusRegisteredClientConverter(OAuth2JacksonProcessor jacksonProcessor, PasswordEncoder passwordEncoder) {
        super(jacksonProcessor);
        this.passwordEncoder = passwordEncoder;
    }

    public HerodotusRegisteredClient convert(RegisteredClient registeredClient) {
        ArrayList clientAuthenticationMethods = new ArrayList(registeredClient.getClientAuthenticationMethods().size());
        registeredClient.getClientAuthenticationMethods().forEach(clientAuthenticationMethod -> clientAuthenticationMethods.add(clientAuthenticationMethod.getValue()));
        ArrayList authorizationGrantTypes = new ArrayList(registeredClient.getAuthorizationGrantTypes().size());
        registeredClient.getAuthorizationGrantTypes().forEach(authorizationGrantType -> authorizationGrantTypes.add(authorizationGrantType.getValue()));
        HerodotusRegisteredClient entity = new HerodotusRegisteredClient();
        entity.setId(registeredClient.getId());
        entity.setClientId(registeredClient.getClientId());
        entity.setClientIdIssuedAt(DateUtil.toLocalDateTime((Instant)registeredClient.getClientIdIssuedAt()));
        entity.setClientSecret(this.encode(registeredClient.getClientSecret()));
        entity.setClientSecretExpiresAt(DateUtil.toLocalDateTime((Instant)registeredClient.getClientSecretExpiresAt()));
        entity.setClientName(registeredClient.getClientName());
        entity.setClientAuthenticationMethods(StringUtils.collectionToCommaDelimitedString(clientAuthenticationMethods));
        entity.setAuthorizationGrantTypes(StringUtils.collectionToCommaDelimitedString(authorizationGrantTypes));
        entity.setRedirectUris(StringUtils.collectionToCommaDelimitedString((Collection)registeredClient.getRedirectUris()));
        entity.setPostLogoutRedirectUris(StringUtils.collectionToCommaDelimitedString((Collection)registeredClient.getPostLogoutRedirectUris()));
        entity.setScopes(StringUtils.collectionToCommaDelimitedString((Collection)registeredClient.getScopes()));
        entity.setClientSettings(this.writeMap(registeredClient.getClientSettings().getSettings()));
        entity.setTokenSettings(this.writeMap(registeredClient.getTokenSettings().getSettings()));
        return entity;
    }

    private String encode(String value) {
        if (value != null) {
            return this.passwordEncoder.encode((CharSequence)value);
        }
        return null;
    }
}

