/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.data.jpa.converter;

import cn.herodotus.engine.oauth2.data.jpa.definition.converter.AbstractOAuth2EntityConverter;
import cn.herodotus.engine.oauth2.data.jpa.entity.HerodotusAuthorization;
import cn.herodotus.engine.oauth2.data.jpa.jackson2.OAuth2JacksonProcessor;
import cn.hutool.v7.core.date.DateUtil;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.function.Consumer;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2DeviceCode;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.OAuth2UserCode;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationCode;
import org.springframework.util.StringUtils;

public class OAuth2ToHerodotusAuthorizationConverter
extends AbstractOAuth2EntityConverter<OAuth2Authorization, HerodotusAuthorization> {
    public OAuth2ToHerodotusAuthorizationConverter(OAuth2JacksonProcessor jacksonProcessor) {
        super(jacksonProcessor);
    }

    public HerodotusAuthorization convert(OAuth2Authorization authorization) {
        HerodotusAuthorization entity = new HerodotusAuthorization();
        entity.setId(authorization.getId());
        entity.setRegisteredClientId(authorization.getRegisteredClientId());
        entity.setPrincipalName(authorization.getPrincipalName());
        entity.setAuthorizationGrantType(authorization.getAuthorizationGrantType().getValue());
        entity.setAuthorizedScopes(StringUtils.collectionToDelimitedString((Collection)authorization.getAuthorizedScopes(), (String)","));
        entity.setAttributes(this.writeMap(authorization.getAttributes()));
        entity.setState((String)authorization.getAttribute("state"));
        OAuth2Authorization.Token authorizationCode = authorization.getToken(OAuth2AuthorizationCode.class);
        this.setTokenValues(authorizationCode, entity::setAuthorizationCodeValue, entity::setAuthorizationCodeIssuedAt, entity::setAuthorizationCodeExpiresAt, entity::setAuthorizationCodeMetadata);
        OAuth2Authorization.Token accessToken = authorization.getToken(OAuth2AccessToken.class);
        this.setTokenValues(accessToken, entity::setAccessTokenValue, entity::setAccessTokenIssuedAt, entity::setAccessTokenExpiresAt, entity::setAccessTokenMetadata);
        if (accessToken != null) {
            if (((OAuth2AccessToken)accessToken.getToken()).getScopes() != null) {
                entity.setAccessTokenScopes(StringUtils.collectionToCommaDelimitedString((Collection)((OAuth2AccessToken)accessToken.getToken()).getScopes()));
            }
            if (((OAuth2AccessToken)accessToken.getToken()).getTokenType() != null) {
                entity.setAccessTokenType(((OAuth2AccessToken)accessToken.getToken()).getTokenType().getValue());
            }
        }
        OAuth2Authorization.Token refreshToken = authorization.getToken(OAuth2RefreshToken.class);
        this.setTokenValues(refreshToken, entity::setRefreshTokenValue, entity::setRefreshTokenIssuedAt, entity::setRefreshTokenExpiresAt, entity::setRefreshTokenMetadata);
        OAuth2Authorization.Token oidcIdToken = authorization.getToken(OidcIdToken.class);
        this.setTokenValues(oidcIdToken, entity::setOidcIdTokenValue, entity::setOidcIdTokenIssuedAt, entity::setOidcIdTokenExpiresAt, entity::setOidcIdTokenMetadata);
        if (oidcIdToken != null) {
            entity.setOidcIdTokenClaims(this.writeMap(oidcIdToken.getClaims()));
        }
        OAuth2Authorization.Token userCode = authorization.getToken(OAuth2UserCode.class);
        this.setTokenValues(userCode, entity::setUserCodeValue, entity::setUserCodeIssuedAt, entity::setUserCodeExpiresAt, entity::setUserCodeMetadata);
        OAuth2Authorization.Token deviceCode = authorization.getToken(OAuth2DeviceCode.class);
        this.setTokenValues(deviceCode, entity::setDeviceCodeValue, entity::setDeviceCodeIssuedAt, entity::setDeviceCodeExpiresAt, entity::setDeviceCodeMetadata);
        return entity;
    }

    private void setTokenValues(OAuth2Authorization.Token<?> token, Consumer<String> tokenValueConsumer, Consumer<LocalDateTime> issuedAtConsumer, Consumer<LocalDateTime> expiresAtConsumer, Consumer<String> metadataConsumer) {
        if (token != null) {
            OAuth2Token oAuth2Token = token.getToken();
            tokenValueConsumer.accept(oAuth2Token.getTokenValue());
            issuedAtConsumer.accept(DateUtil.toLocalDateTime((Instant)oAuth2Token.getIssuedAt()));
            expiresAtConsumer.accept(DateUtil.toLocalDateTime((Instant)oAuth2Token.getExpiresAt()));
            metadataConsumer.accept(this.writeMap(token.getMetadata()));
        }
    }
}

