/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.data.jpa.storage;

import cn.herodotus.engine.assistant.core.definition.domain.Entity;
import cn.herodotus.engine.oauth2.data.jpa.converter.HerodotusToOAuth2AuthorizationConverter;
import cn.herodotus.engine.oauth2.data.jpa.converter.OAuth2ToHerodotusAuthorizationConverter;
import cn.herodotus.engine.oauth2.data.jpa.entity.HerodotusAuthorization;
import cn.herodotus.engine.oauth2.data.jpa.jackson2.OAuth2JacksonProcessor;
import cn.herodotus.engine.oauth2.data.jpa.service.HerodotusAuthorizationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class JpaOAuth2AuthorizationService
implements OAuth2AuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(JpaOAuth2AuthorizationService.class);
    private final HerodotusAuthorizationService herodotusAuthorizationService;
    private final Converter<HerodotusAuthorization, OAuth2Authorization> herodotusToOAuth2Converter;
    private final Converter<OAuth2Authorization, HerodotusAuthorization> oauth2ToHerodotusConverter;

    public JpaOAuth2AuthorizationService(HerodotusAuthorizationService herodotusAuthorizationService, RegisteredClientRepository registeredClientRepository) {
        this.herodotusAuthorizationService = herodotusAuthorizationService;
        OAuth2JacksonProcessor jacksonProcessor = new OAuth2JacksonProcessor();
        this.herodotusToOAuth2Converter = new HerodotusToOAuth2AuthorizationConverter(jacksonProcessor, registeredClientRepository);
        this.oauth2ToHerodotusConverter = new OAuth2ToHerodotusAuthorizationConverter(jacksonProcessor);
    }

    public void save(OAuth2Authorization authorization) {
        this.herodotusAuthorizationService.saveAndFlush((Entity)this.toEntity(authorization));
        log.debug("[Herodotus] |- Jpa OAuth2 Authorization Service save entity.");
    }

    @Transactional
    public void remove(OAuth2Authorization authorization) {
        Assert.notNull((Object)authorization, (String)"authorization cannot be null");
        this.herodotusAuthorizationService.deleteById((Serializable)((Object)authorization.getId()));
        log.debug("[Herodotus] |- Jpa OAuth2 Authorization Service remove entity.");
        this.herodotusAuthorizationService.clearHistoryToken();
        log.debug("[Herodotus] |- Jpa OAuth2 Authorization Service clear history token.");
    }

    public OAuth2Authorization findById(String id) {
        HerodotusAuthorization herodotusAuthorization = (HerodotusAuthorization)this.herodotusAuthorizationService.findById((Serializable)((Object)id));
        if (ObjectUtils.isNotEmpty((Object)((Object)herodotusAuthorization))) {
            log.debug("[Herodotus] |- Jpa OAuth2 Authorization Service findById.");
            return this.toObject(herodotusAuthorization);
        }
        return null;
    }

    public int findAuthorizationCount(String registeredClientId, String principalName) {
        int count = this.herodotusAuthorizationService.findAuthorizationCount(registeredClientId, principalName);
        log.debug("[Herodotus] |- Jpa OAuth2 Authorization Service findAuthorizationCount.");
        return count;
    }

    public List<OAuth2Authorization> findAvailableAuthorizations(String registeredClientId, String principalName) {
        List<HerodotusAuthorization> authorizations = this.herodotusAuthorizationService.findAvailableAuthorizations(registeredClientId, principalName);
        if (CollectionUtils.isNotEmpty(authorizations)) {
            return authorizations.stream().map(this::toObject).collect(Collectors.toList());
        }
        return new ArrayList<OAuth2Authorization>();
    }

    public OAuth2Authorization findByToken(String token, OAuth2TokenType tokenType) {
        Assert.hasText((String)token, (String)"token cannot be empty");
        Optional<HerodotusAuthorization> result = tokenType == null ? this.herodotusAuthorizationService.findByStateOrAuthorizationCodeValueOrAccessTokenValueOrRefreshTokenValueOrOidcIdTokenValueOrUserCodeValueOrDeviceCodeValue(token) : ("state".equals(tokenType.getValue()) ? this.herodotusAuthorizationService.findByState(token) : ("code".equals(tokenType.getValue()) ? this.herodotusAuthorizationService.findByAuthorizationCode(token) : ("access_token".equals(tokenType.getValue()) ? this.herodotusAuthorizationService.findByAccessToken(token) : ("refresh_token".equals(tokenType.getValue()) ? this.herodotusAuthorizationService.findByRefreshToken(token) : ("id_token".equals(tokenType.getValue()) ? this.herodotusAuthorizationService.findByOidcIdTokenValue(token) : ("user_code".equals(tokenType.getValue()) ? this.herodotusAuthorizationService.findByUserCodeValue(token) : ("device_code".equals(tokenType.getValue()) ? this.herodotusAuthorizationService.findByDeviceCodeValue(token) : Optional.empty())))))));
        log.debug("[Herodotus] |- Jpa OAuth2 Authorization Service findByToken.");
        return result.map(this::toObject).orElse(null);
    }

    private OAuth2Authorization toObject(HerodotusAuthorization entity) {
        return (OAuth2Authorization)this.herodotusToOAuth2Converter.convert((Object)entity);
    }

    private HerodotusAuthorization toEntity(OAuth2Authorization authorization) {
        return (HerodotusAuthorization)((Object)this.oauth2ToHerodotusConverter.convert((Object)authorization));
    }
}

