/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.data.jpa.storage;

import cn.herodotus.engine.assistant.core.definition.domain.Entity;
import cn.herodotus.engine.oauth2.data.jpa.adapter.HerodotusRegisteredClientAdapter;
import cn.herodotus.engine.oauth2.data.jpa.entity.HerodotusRegisteredClient;
import cn.herodotus.engine.oauth2.data.jpa.service.HerodotusRegisteredClientService;
import java.io.Serializable;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;

public class JpaRegisteredClientRepository
implements RegisteredClientRepository {
    private static final Logger log = LoggerFactory.getLogger(JpaRegisteredClientRepository.class);
    private final HerodotusRegisteredClientService herodotusRegisteredClientService;
    private final HerodotusRegisteredClientAdapter herodotusRegisteredClientAdapter;

    public JpaRegisteredClientRepository(HerodotusRegisteredClientService herodotusRegisteredClientService, PasswordEncoder passwordEncoder) {
        this.herodotusRegisteredClientService = herodotusRegisteredClientService;
        this.herodotusRegisteredClientAdapter = new HerodotusRegisteredClientAdapter(passwordEncoder);
    }

    public void save(RegisteredClient registeredClient) {
        log.debug("[Herodotus] |- Jpa Registered Client Repository save entity.");
        this.herodotusRegisteredClientService.save((Entity)this.toEntity(registeredClient));
    }

    public RegisteredClient findById(String id) {
        log.debug("[Herodotus] |- Jpa Registered Client Repository findById.");
        HerodotusRegisteredClient herodotusRegisteredClient = (HerodotusRegisteredClient)this.herodotusRegisteredClientService.findById((Serializable)((Object)id));
        if (ObjectUtils.isNotEmpty((Object)((Object)herodotusRegisteredClient))) {
            return this.toObject(herodotusRegisteredClient);
        }
        return null;
    }

    public RegisteredClient findByClientId(String clientId) {
        log.debug("[Herodotus] |- Jpa Registered Client Repository findByClientId.");
        return this.herodotusRegisteredClientService.findByClientId(clientId).map(this::toObject).orElse(null);
    }

    public void remove(String id) {
        log.debug("[Herodotus] |- Jpa Registered Client Repository remove.");
        this.herodotusRegisteredClientService.deleteById((Serializable)((Object)id));
    }

    private RegisteredClient toObject(HerodotusRegisteredClient herodotusRegisteredClient) {
        return this.herodotusRegisteredClientAdapter.toObject(herodotusRegisteredClient);
    }

    private HerodotusRegisteredClient toEntity(RegisteredClient registeredClient) {
        return this.herodotusRegisteredClientAdapter.toEntity(registeredClient);
    }
}

