/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.data.jpa.definition;

import cn.herodotus.engine.oauth2.core.definition.domain.RegisteredClientDetails;
import cn.herodotus.engine.oauth2.core.utils.OAuth2AuthorizationUtils;
import cn.hutool.core.date.DateUtil;
import java.time.temporal.TemporalAccessor;
import java.util.Set;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;
import org.springframework.util.StringUtils;

public interface RegisteredClientAdapter<T extends RegisteredClientDetails> {
    public Set<String> getScopes(T var1);

    public ClientSettings getClientSettings(T var1);

    public TokenSettings getTokenSettings(T var1);

    default public RegisteredClient toObject(T details) {
        Set<String> clientScopes = this.getScopes(details);
        ClientSettings clientSettings = this.getClientSettings(details);
        TokenSettings tokenSettings = this.getTokenSettings(details);
        Set clientAuthenticationMethods = StringUtils.commaDelimitedListToSet((String)details.getClientAuthenticationMethods());
        Set authorizationGrantTypes = StringUtils.commaDelimitedListToSet((String)details.getAuthorizationGrantTypes());
        Set redirectUris = StringUtils.commaDelimitedListToSet((String)details.getRedirectUris());
        Set postLogoutRedirectUris = StringUtils.commaDelimitedListToSet((String)details.getPostLogoutRedirectUris());
        return RegisteredClient.withId((String)details.getId()).clientId(details.getClientId()).clientIdIssuedAt(DateUtil.toInstant((TemporalAccessor)details.getClientIdIssuedAt())).clientSecret(details.getClientSecret()).clientSecretExpiresAt(DateUtil.toInstant((TemporalAccessor)details.getClientSecretExpiresAt())).clientName(details.getClientName()).clientAuthenticationMethods(authenticationMethods -> clientAuthenticationMethods.forEach(authenticationMethod -> authenticationMethods.add(OAuth2AuthorizationUtils.resolveClientAuthenticationMethod((String)authenticationMethod)))).authorizationGrantTypes(grantTypes -> authorizationGrantTypes.forEach(grantType -> grantTypes.add(OAuth2AuthorizationUtils.resolveAuthorizationGrantType((String)grantType)))).redirectUris(uris -> uris.addAll(redirectUris)).postLogoutRedirectUris(uris -> uris.addAll(postLogoutRedirectUris)).scopes(scopes -> scopes.addAll(clientScopes)).clientSettings(clientSettings).tokenSettings(tokenSettings).build();
    }
}

