/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.data.jpa.adapter;

import cn.herodotus.engine.oauth2.data.jpa.definition.AbstractRegisteredClientAdapter;
import cn.herodotus.engine.oauth2.data.jpa.entity.HerodotusRegisteredClient;
import cn.hutool.core.date.DateUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;
import org.springframework.util.StringUtils;

public class HerodotusRegisteredClientAdapter
extends AbstractRegisteredClientAdapter<HerodotusRegisteredClient> {
    private final PasswordEncoder passwordEncoder;

    public HerodotusRegisteredClientAdapter(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Override
    public Set<String> getScopes(HerodotusRegisteredClient details) {
        return StringUtils.commaDelimitedListToSet((String)details.getScopes());
    }

    @Override
    public ClientSettings getClientSettings(HerodotusRegisteredClient details) {
        Map<String, Object> clientSettingsMap = this.parseMap(details.getClientSettings());
        return ClientSettings.withSettings(clientSettingsMap).build();
    }

    @Override
    public TokenSettings getTokenSettings(HerodotusRegisteredClient details) {
        Map<String, Object> tokenSettingsMap = this.parseMap(details.getTokenSettings());
        return TokenSettings.withSettings(tokenSettingsMap).build();
    }

    public HerodotusRegisteredClient toEntity(RegisteredClient registeredClient) {
        ArrayList clientAuthenticationMethods = new ArrayList(registeredClient.getClientAuthenticationMethods().size());
        registeredClient.getClientAuthenticationMethods().forEach(clientAuthenticationMethod -> clientAuthenticationMethods.add(clientAuthenticationMethod.getValue()));
        ArrayList authorizationGrantTypes = new ArrayList(registeredClient.getAuthorizationGrantTypes().size());
        registeredClient.getAuthorizationGrantTypes().forEach(authorizationGrantType -> authorizationGrantTypes.add(authorizationGrantType.getValue()));
        HerodotusRegisteredClient entity = new HerodotusRegisteredClient();
        entity.setId(registeredClient.getId());
        entity.setClientId(registeredClient.getClientId());
        entity.setClientIdIssuedAt(DateUtil.toLocalDateTime((Instant)registeredClient.getClientIdIssuedAt()));
        entity.setClientSecret(this.encode(registeredClient.getClientSecret()));
        entity.setClientSecretExpiresAt(DateUtil.toLocalDateTime((Instant)registeredClient.getClientSecretExpiresAt()));
        entity.setClientName(registeredClient.getClientName());
        entity.setClientAuthenticationMethods(StringUtils.collectionToCommaDelimitedString(clientAuthenticationMethods));
        entity.setAuthorizationGrantTypes(StringUtils.collectionToCommaDelimitedString(authorizationGrantTypes));
        entity.setRedirectUris(StringUtils.collectionToCommaDelimitedString((Collection)registeredClient.getRedirectUris()));
        entity.setPostLogoutRedirectUris(StringUtils.collectionToCommaDelimitedString((Collection)registeredClient.getPostLogoutRedirectUris()));
        entity.setScopes(StringUtils.collectionToCommaDelimitedString((Collection)registeredClient.getScopes()));
        entity.setClientSettings(this.writeMap(registeredClient.getClientSettings().getSettings()));
        entity.setTokenSettings(this.writeMap(registeredClient.getTokenSettings().getSettings()));
        return entity;
    }

    private String encode(String value) {
        if (value != null) {
            return this.passwordEncoder.encode((CharSequence)value);
        }
        return null;
    }
}

