/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.data.jpa.storage;

import cn.herodotus.engine.assistant.core.definition.domain.Entity;
import cn.herodotus.engine.oauth2.core.jackson2.HerodotusJackson2Module;
import cn.herodotus.engine.oauth2.data.jpa.entity.HerodotusRegisteredClient;
import cn.herodotus.engine.oauth2.data.jpa.jackson2.OAuth2TokenJackson2Module;
import cn.herodotus.engine.oauth2.data.jpa.service.HerodotusRegisteredClientService;
import cn.herodotus.engine.oauth2.data.jpa.utils.OAuth2AuthorizationUtils;
import cn.hutool.core.date.DateUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.jackson2.SecurityJackson2Modules;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.jackson2.OAuth2AuthorizationServerJackson2Module;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;
import org.springframework.util.StringUtils;

public class JpaRegisteredClientRepository
implements RegisteredClientRepository {
    private static final Logger log = LoggerFactory.getLogger(JpaRegisteredClientRepository.class);
    private final HerodotusRegisteredClientService herodotusRegisteredClientService;
    private final PasswordEncoder passwordEncoder;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JpaRegisteredClientRepository(HerodotusRegisteredClientService herodotusRegisteredClientService, PasswordEncoder passwordEncoder) {
        this.herodotusRegisteredClientService = herodotusRegisteredClientService;
        this.passwordEncoder = passwordEncoder;
        ClassLoader classLoader = JpaRegisteredClientRepository.class.getClassLoader();
        List securityModules = SecurityJackson2Modules.getModules((ClassLoader)classLoader);
        this.objectMapper.registerModules((Iterable)securityModules);
        this.objectMapper.registerModule((Module)new OAuth2AuthorizationServerJackson2Module());
        this.objectMapper.registerModules(new Module[]{new HerodotusJackson2Module()});
        this.objectMapper.registerModules(new Module[]{new OAuth2TokenJackson2Module()});
    }

    public void save(RegisteredClient registeredClient) {
        log.debug("[Herodotus] |- Jpa Registered Client Repository save entity.");
        this.herodotusRegisteredClientService.save((Entity)this.toEntity(registeredClient));
    }

    public RegisteredClient findById(String id) {
        log.debug("[Herodotus] |- Jpa Registered Client Repository findById.");
        HerodotusRegisteredClient herodotusRegisteredClient = (HerodotusRegisteredClient)this.herodotusRegisteredClientService.findById((Serializable)((Object)id));
        if (ObjectUtils.isNotEmpty((Object)((Object)herodotusRegisteredClient))) {
            return this.toObject(herodotusRegisteredClient);
        }
        return null;
    }

    public RegisteredClient findByClientId(String clientId) {
        log.debug("[Herodotus] |- Jpa Registered Client Repository findByClientId.");
        return this.herodotusRegisteredClientService.findByClientId(clientId).map(this::toObject).orElse(null);
    }

    public void remove(String id) {
        log.debug("[Herodotus] |- Jpa Registered Client Repository remove.");
        this.herodotusRegisteredClientService.deleteById((Serializable)((Object)id));
    }

    private RegisteredClient toObject(HerodotusRegisteredClient herodotusRegisteredClient) {
        Set clientAuthenticationMethods = StringUtils.commaDelimitedListToSet((String)herodotusRegisteredClient.getClientAuthenticationMethods());
        Set authorizationGrantTypes = StringUtils.commaDelimitedListToSet((String)herodotusRegisteredClient.getAuthorizationGrantTypes());
        Set redirectUris = StringUtils.commaDelimitedListToSet((String)herodotusRegisteredClient.getRedirectUris());
        Set clientScopes = StringUtils.commaDelimitedListToSet((String)herodotusRegisteredClient.getScopes());
        RegisteredClient.Builder builder = RegisteredClient.withId((String)herodotusRegisteredClient.getId()).clientId(herodotusRegisteredClient.getClientId()).clientIdIssuedAt(DateUtil.toInstant((TemporalAccessor)herodotusRegisteredClient.getClientIdIssuedAt())).clientSecret(herodotusRegisteredClient.getClientSecret()).clientSecretExpiresAt(DateUtil.toInstant((TemporalAccessor)herodotusRegisteredClient.getClientSecretExpiresAt())).clientName(herodotusRegisteredClient.getClientName()).clientAuthenticationMethods(authenticationMethods -> clientAuthenticationMethods.forEach(authenticationMethod -> authenticationMethods.add(OAuth2AuthorizationUtils.resolveClientAuthenticationMethod(authenticationMethod)))).authorizationGrantTypes(grantTypes -> authorizationGrantTypes.forEach(grantType -> grantTypes.add(OAuth2AuthorizationUtils.resolveAuthorizationGrantType(grantType)))).redirectUris(uris -> uris.addAll(redirectUris)).scopes(scopes -> scopes.addAll(clientScopes));
        Map<String, Object> clientSettingsMap = this.parseMap(herodotusRegisteredClient.getClientSettings());
        builder.clientSettings(ClientSettings.withSettings(clientSettingsMap).build());
        Map<String, Object> tokenSettingsMap = this.parseMap(herodotusRegisteredClient.getTokenSettings());
        builder.tokenSettings(TokenSettings.withSettings(tokenSettingsMap).build());
        return builder.build();
    }

    private HerodotusRegisteredClient toEntity(RegisteredClient registeredClient) {
        ArrayList clientAuthenticationMethods = new ArrayList(registeredClient.getClientAuthenticationMethods().size());
        registeredClient.getClientAuthenticationMethods().forEach(clientAuthenticationMethod -> clientAuthenticationMethods.add(clientAuthenticationMethod.getValue()));
        ArrayList authorizationGrantTypes = new ArrayList(registeredClient.getAuthorizationGrantTypes().size());
        registeredClient.getAuthorizationGrantTypes().forEach(authorizationGrantType -> authorizationGrantTypes.add(authorizationGrantType.getValue()));
        HerodotusRegisteredClient entity = new HerodotusRegisteredClient();
        entity.setId(registeredClient.getId());
        entity.setClientId(registeredClient.getClientId());
        entity.setClientIdIssuedAt(DateUtil.toLocalDateTime((Instant)registeredClient.getClientIdIssuedAt()));
        entity.setClientSecret(this.encode(registeredClient.getClientSecret()));
        entity.setClientSecretExpiresAt(DateUtil.toLocalDateTime((Instant)registeredClient.getClientSecretExpiresAt()));
        entity.setClientName(registeredClient.getClientName());
        entity.setClientAuthenticationMethods(StringUtils.collectionToCommaDelimitedString(clientAuthenticationMethods));
        entity.setAuthorizationGrantTypes(StringUtils.collectionToCommaDelimitedString(authorizationGrantTypes));
        entity.setRedirectUris(StringUtils.collectionToCommaDelimitedString((Collection)registeredClient.getRedirectUris()));
        entity.setScopes(StringUtils.collectionToCommaDelimitedString((Collection)registeredClient.getScopes()));
        entity.setClientSettings(this.writeMap(registeredClient.getClientSettings().getSettings()));
        entity.setTokenSettings(this.writeMap(registeredClient.getTokenSettings().getSettings()));
        return entity;
    }

    private String encode(String value) {
        if (value != null) {
            return this.passwordEncoder.encode((CharSequence)value);
        }
        return null;
    }

    private Map<String, Object> parseMap(String data) {
        try {
            return (Map)this.objectMapper.readValue(data, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    private String writeMap(Map<String, Object> data) {
        try {
            return this.objectMapper.writeValueAsString(data);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }
}

