/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.data.jpa.storage;

import cn.herodotus.engine.assistant.core.definition.domain.Entity;
import cn.herodotus.engine.oauth2.core.jackson2.HerodotusJackson2Module;
import cn.herodotus.engine.oauth2.data.jpa.entity.HerodotusAuthorization;
import cn.herodotus.engine.oauth2.data.jpa.service.HerodotusAuthorizationService;
import cn.herodotus.engine.oauth2.data.jpa.utils.OAuth2AuthorizationUtils;
import cn.hutool.core.date.DateUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.security.jackson2.SecurityJackson2Modules;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthorizationCode;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.OAuth2TokenType;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.jackson2.OAuth2AuthorizationServerJackson2Module;
import org.springframework.util.StringUtils;

public class JpaOAuth2AuthorizationService
implements OAuth2AuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(JpaOAuth2AuthorizationService.class);
    private final HerodotusAuthorizationService herodotusAuthorizationService;
    private final RegisteredClientRepository registeredClientRepository;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JpaOAuth2AuthorizationService(HerodotusAuthorizationService herodotusAuthorizationService, RegisteredClientRepository registeredClientRepository) {
        this.herodotusAuthorizationService = herodotusAuthorizationService;
        this.registeredClientRepository = registeredClientRepository;
        ClassLoader classLoader = JpaOAuth2AuthorizationService.class.getClassLoader();
        List securityModules = SecurityJackson2Modules.getModules((ClassLoader)classLoader);
        this.objectMapper.registerModules((Iterable)securityModules);
        this.objectMapper.registerModule((Module)new OAuth2AuthorizationServerJackson2Module());
        this.objectMapper.registerModules(new Module[]{new HerodotusJackson2Module()});
    }

    public void save(OAuth2Authorization authorization) {
        this.herodotusAuthorizationService.save((Entity)this.toEntity(authorization));
        log.debug("[Herodotus] |- Jpa OAuth2 Authorization Service save entity.");
    }

    public void remove(OAuth2Authorization authorization) {
        if (StringUtils.hasText((String)authorization.getId())) {
            this.herodotusAuthorizationService.deleteById((Serializable)((Object)authorization.getId()));
        } else if (StringUtils.hasText((String)authorization.getRegisteredClientId()) && StringUtils.hasText((String)authorization.getRegisteredClientId())) {
            this.herodotusAuthorizationService.deleteByRegisteredClientIdAndPrincipalName(authorization.getRegisteredClientId(), authorization.getPrincipalName());
        } else {
            this.herodotusAuthorizationService.clearExpireAccessToken();
        }
        log.debug("[Herodotus] |- Jpa OAuth2 Authorization Service remove entity.");
    }

    public OAuth2Authorization findById(String id) {
        HerodotusAuthorization herodotusAuthorization = (HerodotusAuthorization)this.herodotusAuthorizationService.findById((Serializable)((Object)id));
        if (ObjectUtils.isNotEmpty((Object)((Object)herodotusAuthorization))) {
            log.debug("[Herodotus] |- Jpa OAuth2 Authorization Service findById.");
            return this.toObject(herodotusAuthorization);
        }
        return null;
    }

    public int findAuthorizationCount(String registeredClientId, String principalName) {
        int count = this.herodotusAuthorizationService.findAuthorizationCount(registeredClientId, principalName);
        log.debug("[Herodotus] |- Jpa OAuth2 Authorization Service findAuthorizationCount.");
        return count;
    }

    public OAuth2Authorization findByToken(String token, OAuth2TokenType tokenType) {
        Optional<HerodotusAuthorization> result = tokenType == null ? this.herodotusAuthorizationService.findByDetection(token) : ("access_token".equals(tokenType.getValue()) ? this.herodotusAuthorizationService.findByAccessToken(token) : ("refresh_token".equals(tokenType.getValue()) ? this.herodotusAuthorizationService.findByRefreshToken(token) : ("state".equals(tokenType.getValue()) ? this.herodotusAuthorizationService.findByState(token) : ("code".equals(tokenType.getValue()) ? this.herodotusAuthorizationService.findByAuthorizationCode(token) : Optional.empty()))));
        log.debug("[Herodotus] |- Jpa OAuth2 Authorization Service findByToken.");
        return result.map(this::toObject).orElse(null);
    }

    private OAuth2Authorization toObject(HerodotusAuthorization entity) {
        RegisteredClient registeredClient = this.registeredClientRepository.findById(entity.getRegisteredClientId());
        if (registeredClient == null) {
            throw new DataRetrievalFailureException("The RegisteredClient with id '" + entity.getRegisteredClientId() + "' was not found in the RegisteredClientRepository.");
        }
        OAuth2Authorization.Builder builder = OAuth2Authorization.withRegisteredClient((RegisteredClient)registeredClient).id(entity.getId()).principalName(entity.getPrincipalName()).authorizationGrantType(OAuth2AuthorizationUtils.resolveAuthorizationGrantType(entity.getAuthorizationGrantType())).attributes(attributes -> attributes.putAll(this.parseMap(entity.getAttributes())));
        if (entity.getState() != null) {
            builder.attribute("state", (Object)entity.getState());
        }
        if (entity.getAuthorizationCode() != null) {
            OAuth2AuthorizationCode authorizationCode = new OAuth2AuthorizationCode(entity.getAuthorizationCode(), DateUtil.toInstant((TemporalAccessor)entity.getAuthorizationCodeIssuedAt()), DateUtil.toInstant((TemporalAccessor)entity.getAuthorizationCodeExpiresAt()));
            builder.token((OAuth2Token)authorizationCode, metadata -> metadata.putAll(this.parseMap(entity.getAuthorizationCodeMetadata())));
        }
        if (entity.getAccessToken() != null) {
            OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, entity.getAccessToken(), DateUtil.toInstant((TemporalAccessor)entity.getAccessTokenIssuedAt()), DateUtil.toInstant((TemporalAccessor)entity.getAccessTokenExpiresAt()), StringUtils.commaDelimitedListToSet((String)entity.getAccessTokenScopes()));
            builder.token((OAuth2Token)accessToken, metadata -> metadata.putAll(this.parseMap(entity.getAccessTokenMetadata())));
        }
        if (entity.getRefreshToken() != null) {
            OAuth2RefreshToken refreshToken = new OAuth2RefreshToken(entity.getRefreshToken(), DateUtil.toInstant((TemporalAccessor)entity.getRefreshTokenIssuedAt()), DateUtil.toInstant((TemporalAccessor)entity.getRefreshTokenExpiresAt()));
            builder.token((OAuth2Token)refreshToken, metadata -> metadata.putAll(this.parseMap(entity.getRefreshTokenMetadata())));
        }
        if (entity.getOidcIdToken() != null) {
            OidcIdToken idToken = new OidcIdToken(entity.getOidcIdToken(), DateUtil.toInstant((TemporalAccessor)entity.getOidcIdTokenIssuedAt()), DateUtil.toInstant((TemporalAccessor)entity.getOidcIdTokenExpiresAt()), this.parseMap(entity.getOidcIdTokenClaims()));
            builder.token((OAuth2Token)idToken, metadata -> metadata.putAll(this.parseMap(entity.getOidcIdTokenMetadata())));
        }
        return builder.build();
    }

    private HerodotusAuthorization toEntity(OAuth2Authorization authorization) {
        HerodotusAuthorization entity = new HerodotusAuthorization();
        entity.setId(authorization.getId());
        entity.setRegisteredClientId(authorization.getRegisteredClientId());
        entity.setPrincipalName(authorization.getPrincipalName());
        entity.setAuthorizationGrantType(authorization.getAuthorizationGrantType().getValue());
        entity.setAttributes(this.writeMap(authorization.getAttributes()));
        entity.setState((String)authorization.getAttribute("state"));
        OAuth2Authorization.Token authorizationCode = authorization.getToken(OAuth2AuthorizationCode.class);
        this.setTokenValues(authorizationCode, entity::setAuthorizationCode, entity::setAuthorizationCodeIssuedAt, entity::setAuthorizationCodeExpiresAt, entity::setAuthorizationCodeMetadata);
        OAuth2Authorization.Token accessToken = authorization.getToken(OAuth2AccessToken.class);
        this.setTokenValues(accessToken, entity::setAccessToken, entity::setAccessTokenIssuedAt, entity::setAccessTokenExpiresAt, entity::setAccessTokenMetadata);
        if (accessToken != null && ((OAuth2AccessToken)accessToken.getToken()).getScopes() != null) {
            entity.setAccessTokenScopes(StringUtils.collectionToDelimitedString((Collection)((OAuth2AccessToken)accessToken.getToken()).getScopes(), (String)","));
        }
        OAuth2Authorization.Token refreshToken = authorization.getToken(OAuth2RefreshToken.class);
        this.setTokenValues(refreshToken, entity::setRefreshToken, entity::setRefreshTokenIssuedAt, entity::setRefreshTokenExpiresAt, entity::setRefreshTokenMetadata);
        OAuth2Authorization.Token oidcIdToken = authorization.getToken(OidcIdToken.class);
        this.setTokenValues(oidcIdToken, entity::setOidcIdToken, entity::setOidcIdTokenIssuedAt, entity::setOidcIdTokenExpiresAt, entity::setOidcIdTokenMetadata);
        if (oidcIdToken != null) {
            entity.setOidcIdTokenClaims(this.writeMap(oidcIdToken.getClaims()));
        }
        return entity;
    }

    private void setTokenValues(OAuth2Authorization.Token<?> token, Consumer<String> tokenValueConsumer, Consumer<LocalDateTime> issuedAtConsumer, Consumer<LocalDateTime> expiresAtConsumer, Consumer<String> metadataConsumer) {
        if (token != null) {
            OAuth2Token oAuth2Token = token.getToken();
            tokenValueConsumer.accept(oAuth2Token.getTokenValue());
            issuedAtConsumer.accept(DateUtil.toLocalDateTime((Instant)oAuth2Token.getIssuedAt()));
            expiresAtConsumer.accept(DateUtil.toLocalDateTime((Instant)oAuth2Token.getExpiresAt()));
            metadataConsumer.accept(this.writeMap(token.getMetadata()));
        }
    }

    private Map<String, Object> parseMap(String data) {
        try {
            return (Map)this.objectMapper.readValue(data, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    private String writeMap(Map<String, Object> data) {
        try {
            return this.objectMapper.writeValueAsString(data);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }
}

