/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.data.jpa.storage;

import cn.herodotus.engine.assistant.core.definition.domain.Entity;
import cn.herodotus.engine.oauth2.data.jpa.entity.HerodotusAuthorizationConsent;
import cn.herodotus.engine.oauth2.data.jpa.service.HerodotusAuthorizationConsentService;
import cn.herodotus.engine.security.core.definition.domain.HerodotusGrantedAuthority;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsent;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.util.StringUtils;

public class JpaOAuth2AuthorizationConsentService
implements OAuth2AuthorizationConsentService {
    private static final Logger log = LoggerFactory.getLogger(JpaOAuth2AuthorizationConsentService.class);
    private final HerodotusAuthorizationConsentService herodotusAuthorizationConsentService;
    private final RegisteredClientRepository registeredClientRepository;

    public JpaOAuth2AuthorizationConsentService(HerodotusAuthorizationConsentService herodotusAuthorizationConsentService, RegisteredClientRepository registeredClientRepository) {
        this.herodotusAuthorizationConsentService = herodotusAuthorizationConsentService;
        this.registeredClientRepository = registeredClientRepository;
    }

    public void save(OAuth2AuthorizationConsent authorizationConsent) {
        log.debug("[Herodotus] |- Jpa OAuth2 Authorization Consent Service save entity.");
        this.herodotusAuthorizationConsentService.save((Entity)this.toEntity(authorizationConsent));
    }

    public void remove(OAuth2AuthorizationConsent authorizationConsent) {
        log.debug("[Herodotus] |- Jpa OAuth2 Authorization Consent Service remove entity.");
        this.herodotusAuthorizationConsentService.deleteByRegisteredClientIdAndPrincipalName(authorizationConsent.getRegisteredClientId(), authorizationConsent.getPrincipalName());
    }

    public OAuth2AuthorizationConsent findById(String registeredClientId, String principalName) {
        log.debug("[Herodotus] |- Jpa OAuth2 Authorization Consent Service findById.");
        return this.herodotusAuthorizationConsentService.findByRegisteredClientIdAndPrincipalName(registeredClientId, principalName).map(this::toObject).orElse(null);
    }

    private OAuth2AuthorizationConsent toObject(HerodotusAuthorizationConsent authorizationConsent) {
        String registeredClientId = authorizationConsent.getRegisteredClientId();
        RegisteredClient registeredClient = this.registeredClientRepository.findById(registeredClientId);
        if (registeredClient == null) {
            throw new DataRetrievalFailureException("The RegisteredClient with id '" + registeredClientId + "' was not found in the RegisteredClientRepository.");
        }
        OAuth2AuthorizationConsent.Builder builder = OAuth2AuthorizationConsent.withId((String)registeredClientId, (String)authorizationConsent.getPrincipalName());
        if (authorizationConsent.getAuthorities() != null) {
            for (String authority : StringUtils.commaDelimitedListToSet((String)authorizationConsent.getAuthorities())) {
                builder.authority((GrantedAuthority)new HerodotusGrantedAuthority(authority));
            }
        }
        return builder.build();
    }

    private HerodotusAuthorizationConsent toEntity(OAuth2AuthorizationConsent authorizationConsent) {
        HerodotusAuthorizationConsent entity = new HerodotusAuthorizationConsent();
        entity.setRegisteredClientId(authorizationConsent.getRegisteredClientId());
        entity.setPrincipalName(authorizationConsent.getPrincipalName());
        HashSet<String> authorities = new HashSet<String>();
        for (GrantedAuthority authority : authorizationConsent.getAuthorities()) {
            authorities.add(authority.getAuthority());
        }
        entity.setAuthorities(StringUtils.collectionToCommaDelimitedString(authorities));
        return entity;
    }
}

