/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.stamp;

import cn.herodotus.engine.cache.jetcache.stamp.AbstractCountStampManager;
import cn.herodotus.engine.oauth2.authentication.dto.SignInErrorStatus;
import cn.herodotus.engine.oauth2.authentication.properties.OAuth2AuthenticationProperties;
import cn.hutool.v7.crypto.SecureUtil;
import org.apache.commons.lang3.ObjectUtils;

public class SignInFailureLimitedStampManager
extends AbstractCountStampManager {
    private final OAuth2AuthenticationProperties authenticationProperties;

    public SignInFailureLimitedStampManager(OAuth2AuthenticationProperties authenticationProperties) {
        super("cache:token:sign_in:failure_limited:");
        this.authenticationProperties = authenticationProperties;
    }

    public Long nextStamp(String key) {
        return 1L;
    }

    public void afterPropertiesSet() throws Exception {
        super.setExpire(this.authenticationProperties.getSignInFailureLimited().getExpire());
    }

    public OAuth2AuthenticationProperties getAuthenticationProperties() {
        return this.authenticationProperties;
    }

    public SignInErrorStatus errorStatus(String username) {
        int maxTimes = this.authenticationProperties.getSignInFailureLimited().getMaxTimes();
        Long storedTimes = (Long)this.get(SecureUtil.md5((String)username));
        int errorTimes = 0;
        if (ObjectUtils.isNotEmpty((Object)storedTimes)) {
            errorTimes = storedTimes.intValue();
        }
        int remainTimes = maxTimes;
        if (errorTimes != 0) {
            remainTimes = maxTimes - errorTimes;
        }
        boolean isLocked = false;
        if (errorTimes == maxTimes) {
            isLocked = true;
        }
        SignInErrorStatus status = new SignInErrorStatus();
        status.setErrorTimes(errorTimes);
        status.setRemainTimes(remainTimes);
        status.setLocked(isLocked);
        return status;
    }
}

