/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.utils;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class OAuth2EndpointUtils {
    public static final String ACCESS_TOKEN_REQUEST_ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2";

    private OAuth2EndpointUtils() {
    }

    public static MultiValueMap<String, String> getParameters(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap(parameterMap.size());
        parameterMap.forEach((arg_0, arg_1) -> OAuth2EndpointUtils.lambda$getParameters$0((MultiValueMap)parameters, arg_0, arg_1));
        return parameters;
    }

    public static void throwError(String errorCode, String parameterName) {
        OAuth2EndpointUtils.throwError(errorCode, parameterName, ACCESS_TOKEN_REQUEST_ERROR_URI);
    }

    public static void throwError(String errorCode, String parameterName, String errorUri) {
        OAuth2Error error = new OAuth2Error(errorCode, "OAuth 2.0 Parameter: " + parameterName, errorUri);
        throw new OAuth2AuthenticationException(error);
    }

    private static boolean checkRequired(MultiValueMap<String, String> parameters, String parameterName, String parameterValue) {
        return !StringUtils.hasText((String)parameterValue) || ((List)parameters.get((Object)parameterName)).size() != 1;
    }

    private static boolean checkOptional(MultiValueMap<String, String> parameters, String parameterName, String parameterValue) {
        return StringUtils.hasText((String)parameterValue) && ((List)parameters.get((Object)parameterName)).size() != 1;
    }

    public static String checkParameter(MultiValueMap<String, String> parameters, String parameterName, boolean isRequired, String errorCode, String errorUri) {
        String value = (String)parameters.getFirst((Object)parameterName);
        if (isRequired) {
            if (OAuth2EndpointUtils.checkRequired(parameters, parameterName, value)) {
                OAuth2EndpointUtils.throwError(errorCode, parameterName, errorUri);
            }
        } else if (OAuth2EndpointUtils.checkOptional(parameters, parameterName, value)) {
            OAuth2EndpointUtils.throwError(errorCode, parameterName, errorUri);
        }
        return value;
    }

    public static String checkRequiredParameter(MultiValueMap<String, String> parameters, String parameterName, String errorCode, String errorUri) {
        return OAuth2EndpointUtils.checkParameter(parameters, parameterName, true, errorCode, errorUri);
    }

    public static String checkRequiredParameter(MultiValueMap<String, String> parameters, String parameterName, String errorCode) {
        return OAuth2EndpointUtils.checkRequiredParameter(parameters, parameterName, errorCode, ACCESS_TOKEN_REQUEST_ERROR_URI);
    }

    public static String checkRequiredParameter(MultiValueMap<String, String> parameters, String parameterName) {
        return OAuth2EndpointUtils.checkRequiredParameter(parameters, parameterName, "invalid_request");
    }

    public static String checkOptionalParameter(MultiValueMap<String, String> parameters, String parameterName, String errorCode, String errorUri) {
        return OAuth2EndpointUtils.checkParameter(parameters, parameterName, false, errorCode, errorUri);
    }

    public static String checkOptionalParameter(MultiValueMap<String, String> parameters, String parameterName, String errorCode) {
        return OAuth2EndpointUtils.checkOptionalParameter(parameters, parameterName, errorCode, ACCESS_TOKEN_REQUEST_ERROR_URI);
    }

    public static String checkOptionalParameter(MultiValueMap<String, String> parameters, String parameterName) {
        return OAuth2EndpointUtils.checkOptionalParameter(parameters, parameterName, "invalid_request");
    }

    public static void validateAndAddDPoPParametersIfAvailable(HttpServletRequest request, Map<String, Object> additionalParameters) {
        String dPoPProofHeaderName = OAuth2AccessToken.TokenType.DPOP.getValue();
        String dPoPProof = request.getHeader(dPoPProofHeaderName);
        if (StringUtils.hasText((String)dPoPProof)) {
            if (Collections.list(request.getHeaders(dPoPProofHeaderName)).size() != 1) {
                OAuth2EndpointUtils.throwError("invalid_request", dPoPProofHeaderName, ACCESS_TOKEN_REQUEST_ERROR_URI);
            } else {
                additionalParameters.put("dpop_proof", dPoPProof);
                additionalParameters.put("dpop_method", request.getMethod());
                additionalParameters.put("dpop_target_uri", request.getRequestURL().toString());
            }
        }
    }

    private static /* synthetic */ void lambda$getParameters$0(MultiValueMap parameters, String key, String[] values) {
        for (String value : values) {
            parameters.add((Object)key, (Object)value);
        }
    }
}

