/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.customizer;

import cn.herodotus.engine.oauth2.authentication.properties.OAuth2AuthenticationProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;

public class OAuth2FormLoginConfigurerCustomizer
implements Customizer<FormLoginConfigurer<HttpSecurity>> {
    private final OAuth2AuthenticationProperties authenticationProperties;

    public OAuth2FormLoginConfigurerCustomizer(OAuth2AuthenticationProperties authenticationProperties) {
        this.authenticationProperties = authenticationProperties;
    }

    public void customize(FormLoginConfigurer<HttpSecurity> configurer) {
        configurer.loginPage(this.getFormLogin().getLoginPageUrl()).usernameParameter(this.getFormLogin().getUsernameParameter()).passwordParameter(this.getFormLogin().getPasswordParameter());
        if (StringUtils.isNotBlank((CharSequence)this.getFormLogin().getFailureUrl())) {
            configurer.failureForwardUrl(this.getFormLogin().getFailureUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getFormLogin().getAuthenticationUrl())) {
            configurer.successForwardUrl(this.getFormLogin().getAuthenticationUrl());
        }
    }

    private OAuth2AuthenticationProperties.FormLogin getFormLogin() {
        return this.authenticationProperties.getFormLogin();
    }
}

