/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.configurer;

import cn.herodotus.engine.assistant.core.utils.http.SessionUtils;
import cn.herodotus.engine.oauth2.authentication.properties.OAuth2AuthenticationProperties;
import cn.herodotus.engine.oauth2.core.definition.details.FormLoginWebAuthenticationDetails;
import cn.herodotus.engine.rest.protect.crypto.processor.HttpCryptoProcessor;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.AuthenticationDetailsSource;

public class OAuth2FormLoginWebAuthenticationDetailSource
implements AuthenticationDetailsSource<HttpServletRequest, FormLoginWebAuthenticationDetails> {
    private final OAuth2AuthenticationProperties authenticationProperties;
    private final HttpCryptoProcessor httpCryptoProcessor;

    public OAuth2FormLoginWebAuthenticationDetailSource(OAuth2AuthenticationProperties authenticationProperties, HttpCryptoProcessor httpCryptoProcessor) {
        this.authenticationProperties = authenticationProperties;
        this.httpCryptoProcessor = httpCryptoProcessor;
    }

    public FormLoginWebAuthenticationDetails buildDetails(HttpServletRequest request) {
        String encryptedCode = request.getParameter(this.authenticationProperties.getFormLogin().getCaptchaParameter());
        String sessionId = SessionUtils.analyseSessionId((HttpServletRequest)request);
        String code = null;
        if (StringUtils.isNotBlank((CharSequence)sessionId) && StringUtils.isNotBlank((CharSequence)encryptedCode)) {
            code = this.httpCryptoProcessor.decrypt(sessionId, encryptedCode);
        }
        return new FormLoginWebAuthenticationDetails(request, this.authenticationProperties.getFormLogin().getCaptchaEnabled(), this.authenticationProperties.getFormLogin().getCaptchaParameter(), this.authenticationProperties.getFormLogin().getCategory(), code);
    }
}

