/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.provider;

import cn.herodotus.engine.assistant.core.enums.AccountType;
import cn.herodotus.engine.oauth2.authentication.provider.AbstractAuthenticationConverter;
import cn.herodotus.engine.oauth2.authentication.provider.OAuth2SocialCredentialsAuthenticationToken;
import cn.herodotus.engine.oauth2.authentication.utils.OAuth2EndpointUtils;
import cn.herodotus.engine.oauth2.core.definition.HerodotusGrantType;
import cn.herodotus.engine.rest.protect.crypto.processor.HttpCryptoProcessor;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.security.core.Authentication;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class OAuth2SocialCredentialsAuthenticationConverter
extends AbstractAuthenticationConverter {
    public OAuth2SocialCredentialsAuthenticationConverter(HttpCryptoProcessor httpCryptoProcessor) {
        super(httpCryptoProcessor);
    }

    public Authentication convert(HttpServletRequest request) {
        AccountType accountType;
        String grantType = request.getParameter("grant_type");
        if (!HerodotusGrantType.SOCIAL.getValue().equals(grantType)) {
            return null;
        }
        MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getParameters(request);
        String scope = OAuth2EndpointUtils.checkOptionalParameter(parameters, "scope");
        String source = OAuth2EndpointUtils.checkRequiredParameter(parameters, "source");
        if (StringUtils.hasText((String)source) && ObjectUtils.isNotEmpty((Object)(accountType = AccountType.getAccountType((String)source)))) {
            switch (accountType.getHandler()) {
                case "PHONE_NUMBER": {
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "mobile");
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "code");
                    break;
                }
                case "WECHAT_MINI_APP": {
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "appId");
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "sessionKey");
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "encryptedData");
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "iv");
                    break;
                }
            }
        }
        Map<String, Object> additionalParameters = this.getAdditionalParameters(request, parameters);
        OAuth2EndpointUtils.validateAndAddDPoPParametersIfAvailable(request, additionalParameters);
        return new OAuth2SocialCredentialsAuthenticationToken(this.getClientPrincipal(), this.getRequestedScopes(scope), additionalParameters);
    }
}

