/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.utils;

import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2TokenExchangeActor;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2TokenExchangeCompositeAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenClaimsContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;

final class DefaultOAuth2TokenCustomizers {
    private DefaultOAuth2TokenCustomizers() {
    }

    static OAuth2TokenCustomizer<JwtEncodingContext> jwtCustomizer() {
        return context -> context.getClaims().claims(claims -> DefaultOAuth2TokenCustomizers.customize(context, claims));
    }

    static OAuth2TokenCustomizer<OAuth2TokenClaimsContext> accessTokenCustomizer() {
        return context -> context.getClaims().claims(claims -> DefaultOAuth2TokenCustomizers.customize(context, claims));
    }

    private static void customize(OAuth2TokenContext tokenContext, Map<String, Object> claims) {
        X509Certificate[] clientCertificateChain;
        OAuth2ClientAuthenticationToken clientAuthentication;
        Object object;
        if (OAuth2TokenType.ACCESS_TOKEN.equals((Object)tokenContext.getTokenType()) && tokenContext.getAuthorizationGrant() != null && (object = tokenContext.getAuthorizationGrant().getPrincipal()) instanceof OAuth2ClientAuthenticationToken && (ClientAuthenticationMethod.TLS_CLIENT_AUTH.equals((Object)(clientAuthentication = (OAuth2ClientAuthenticationToken)object).getClientAuthenticationMethod()) || ClientAuthenticationMethod.SELF_SIGNED_TLS_CLIENT_AUTH.equals((Object)clientAuthentication.getClientAuthenticationMethod())) && tokenContext.getRegisteredClient().getTokenSettings().isX509CertificateBoundAccessTokens()) {
            clientCertificateChain = (X509Certificate[])clientAuthentication.getCredentials();
            try {
                String sha256Thumbprint = DefaultOAuth2TokenCustomizers.computeSHA256Thumbprint(clientCertificateChain[0]);
                HashMap<String, String> x5tClaim = new HashMap<String, String>();
                x5tClaim.put("x5t#S256", sha256Thumbprint);
                claims.put("cnf", x5tClaim);
            }
            catch (Exception ex) {
                OAuth2Error error = new OAuth2Error("server_error", "Failed to compute SHA-256 Thumbprint for client X509Certificate.", null);
                throw new OAuth2AuthenticationException(error, (Throwable)ex);
            }
        }
        if ((clientCertificateChain = tokenContext.getPrincipal()) instanceof OAuth2TokenExchangeCompositeAuthenticationToken) {
            OAuth2TokenExchangeCompositeAuthenticationToken compositeAuthenticationToken = (OAuth2TokenExchangeCompositeAuthenticationToken)clientCertificateChain;
            Map<String, Object> currentClaims = claims;
            for (OAuth2TokenExchangeActor actor : compositeAuthenticationToken.getActors()) {
                Map actorClaims = actor.getClaims();
                LinkedHashMap<String, Object> actClaim = new LinkedHashMap<String, Object>();
                actClaim.put("iss", actorClaims.get("iss"));
                actClaim.put("sub", actorClaims.get("sub"));
                currentClaims.put("act", Collections.unmodifiableMap(actClaim));
                currentClaims = actClaim;
            }
        }
    }

    private static String computeSHA256Thumbprint(X509Certificate x509Certificate) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] digest = md.digest(x509Certificate.getEncoded());
        return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
    }
}

