/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.configurer;

import cn.herodotus.engine.assistant.core.utils.http.SessionUtils;
import cn.herodotus.engine.oauth2.authentication.provider.OAuth2FormLoginAuthenticationToken;
import cn.herodotus.engine.rest.protect.crypto.processor.HttpCryptoProcessor;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class OAuth2FormLoginAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(OAuth2FormLoginAuthenticationFilter.class);
    private final HttpCryptoProcessor httpCryptoProcessor;
    private boolean postOnly = true;

    public OAuth2FormLoginAuthenticationFilter(AuthenticationManager authenticationManager, HttpCryptoProcessor httpCryptoProcessor) {
        super(authenticationManager);
        this.httpCryptoProcessor = httpCryptoProcessor;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        if (this.postOnly && !request.getMethod().equals("POST")) {
            throw new AuthenticationServiceException("Authentication method not supported: " + request.getMethod());
        }
        OAuth2FormLoginAuthenticationToken authRequest = this.getAuthenticationToken(request);
        this.setDetails(request, authRequest);
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    private OAuth2FormLoginAuthenticationToken getAuthenticationToken(HttpServletRequest request) {
        String username = this.obtainUsername(request);
        String password = this.obtainPassword(request);
        String sessionId = SessionUtils.analyseSessionId((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)username)) {
            username = "";
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            password = "";
        }
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
            username = this.httpCryptoProcessor.decrypt(sessionId, username);
            password = this.httpCryptoProcessor.decrypt(sessionId, password);
            log.debug("[Herodotus] |- Decrypt Username is : [{}], Password is : [{}]", (Object)username, (Object)password);
        }
        return new OAuth2FormLoginAuthenticationToken(username, password);
    }

    public void setPostOnly(boolean postOnly) {
        super.setPostOnly(postOnly);
        this.postOnly = postOnly;
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        SecurityContextHolder.clearContext();
        this.getRememberMeServices().loginFail(request, response);
        this.getFailureHandler().onAuthenticationFailure(request, response, failed);
    }
}

