/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.provider;

import cn.herodotus.engine.oauth2.authentication.properties.OAuth2AuthenticationProperties;
import cn.herodotus.engine.oauth2.authentication.provider.AbstractAuthenticationProvider;
import cn.herodotus.engine.oauth2.authentication.utils.OAuth2AuthenticationProviderUtils;
import cn.herodotus.engine.oauth2.authentication.utils.OAuth2EndpointUtils;
import cn.herodotus.engine.oauth2.core.definition.service.EnhanceUserDetailsService;
import cn.herodotus.engine.oauth2.core.exception.AccountEndpointLimitedException;
import cn.herodotus.engine.oauth2.data.jpa.storage.JpaOAuth2AuthorizationService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.AccountStatusException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.util.Assert;

public abstract class AbstractUserDetailsAuthenticationProvider
extends AbstractAuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractUserDetailsAuthenticationProvider.class);
    private final MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private final UserDetailsService userDetailsService;
    private final OAuth2AuthorizationService authorizationService;
    private final OAuth2AuthenticationProperties authenticationProperties;
    private PasswordEncoder passwordEncoder;

    public AbstractUserDetailsAuthenticationProvider(OAuth2AuthorizationService authorizationService, UserDetailsService userDetailsService, OAuth2AuthenticationProperties authenticationProperties) {
        this.userDetailsService = userDetailsService;
        this.authorizationService = authorizationService;
        this.authenticationProperties = authenticationProperties;
        this.setPasswordEncoder(PasswordEncoderFactories.createDelegatingPasswordEncoder());
    }

    public EnhanceUserDetailsService getUserDetailsService() {
        return (EnhanceUserDetailsService)this.userDetailsService;
    }

    protected PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        Assert.notNull((Object)passwordEncoder, (String)"passwordEncoder cannot be null");
        this.passwordEncoder = passwordEncoder;
    }

    protected abstract void additionalAuthenticationChecks(UserDetails var1, Map<String, Object> var2) throws AuthenticationException;

    protected abstract UserDetails retrieveUser(Map<String, Object> var1) throws AuthenticationException;

    private Authentication authenticateUserDetails(Map<String, Object> additionalParameters, String registeredClientId) throws AuthenticationException {
        List authorizations;
        OAuth2AuthorizationService count2;
        JpaOAuth2AuthorizationService jpaOAuth2AuthorizationService;
        int count2;
        OAuth2AuthorizationService oAuth2AuthorizationService;
        UserDetails user = this.retrieveUser(additionalParameters);
        if (!user.isAccountNonLocked()) {
            log.debug("[Herodotus] |- Failed to authenticate since user account is locked");
            throw new LockedException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.locked", "User account is locked"));
        }
        if (!user.isEnabled()) {
            log.debug("[Herodotus] |- Failed to authenticate since user account is disabled");
            throw new DisabledException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.disabled", "User is disabled"));
        }
        if (!user.isAccountNonExpired()) {
            log.debug("[Herodotus] |- Failed to authenticate since user account has expired");
            throw new AccountExpiredException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.expired", "User account has expired"));
        }
        this.additionalAuthenticationChecks(user, additionalParameters);
        if (!user.isCredentialsNonExpired()) {
            log.debug("[Herodotus] |- Failed to authenticate since user account credentials have expired");
            throw new CredentialsExpiredException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.credentialsExpired", "User credentials have expired"));
        }
        if (this.authenticationProperties.getSignInEndpointLimited().getEnabled().booleanValue() && !this.authenticationProperties.getSignInKickOutLimited().getEnabled().booleanValue() && (oAuth2AuthorizationService = this.authorizationService) instanceof JpaOAuth2AuthorizationService && (count2 = (jpaOAuth2AuthorizationService = (JpaOAuth2AuthorizationService)oAuth2AuthorizationService).findAuthorizationCount(registeredClientId, user.getUsername())) >= this.authenticationProperties.getSignInEndpointLimited().getMaximum()) {
            throw new AccountEndpointLimitedException("Use same endpoint signIn exceed limit");
        }
        if (!this.authenticationProperties.getSignInEndpointLimited().getEnabled().booleanValue() && this.authenticationProperties.getSignInKickOutLimited().getEnabled().booleanValue() && (count2 = this.authorizationService) instanceof JpaOAuth2AuthorizationService && CollectionUtils.isNotEmpty((Collection)(authorizations = (jpaOAuth2AuthorizationService = (JpaOAuth2AuthorizationService)count2).findAvailableAuthorizations(registeredClientId, user.getUsername())))) {
            authorizations.forEach(authorization -> {
                OAuth2Authorization.Token refreshToken = authorization.getToken(OAuth2RefreshToken.class);
                if (ObjectUtils.isNotEmpty((Object)refreshToken)) {
                    authorization = OAuth2AuthenticationProviderUtils.invalidate(authorization, (OAuth2RefreshToken)refreshToken.getToken());
                }
                log.debug("[Herodotus] |- Sign in user [{}] with token id [{}] will be kicked out.", (Object)user.getUsername(), (Object)authorization.getId());
                jpaOAuth2AuthorizationService.save(authorization);
            });
        }
        return new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
    }

    protected Authentication getUsernamePasswordAuthentication(Map<String, Object> additionalParameters, String registeredClientId) throws AuthenticationException {
        Authentication authentication = null;
        try {
            authentication = this.authenticateUserDetails(additionalParameters, registeredClientId);
        }
        catch (AccountStatusException ase) {
            String exceptionName = ((Object)((Object)ase)).getClass().getSimpleName();
            OAuth2EndpointUtils.throwError(exceptionName, ase.getMessage(), "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
        }
        catch (BadCredentialsException bce) {
            OAuth2EndpointUtils.throwError("BadCredentialsException", bce.getMessage(), "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
        }
        catch (UsernameNotFoundException unfe) {
            OAuth2EndpointUtils.throwError("UsernameNotFoundException", unfe.getMessage(), "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
        }
        return authentication;
    }
}

