/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.customizer;

import cn.herodotus.engine.oauth2.core.definition.domain.HerodotusUser;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AccessTokenAuthenticationToken;

public abstract class AbstractTokenCustomizer {
    protected void appendAll(Map<String, Object> attributes, Authentication authentication, Set<String> authorizedScopes) {
        this.appendAuthorities(attributes, authentication);
        this.appendCommons(attributes, authentication, authorizedScopes);
    }

    protected void appendAuthorities(Map<String, Object> attributes, Authentication authentication) {
        if (CollectionUtils.isNotEmpty((Collection)authentication.getAuthorities())) {
            Set authorities = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
            attributes.put("authorities", authorities);
        }
    }

    protected void appendCommons(Map<String, Object> attributes, Authentication authentication, Set<String> authorizedScopes) {
        if (CollectionUtils.isNotEmpty(authorizedScopes)) {
            attributes.put("scope", authorizedScopes);
        }
        if (authentication instanceof UsernamePasswordAuthenticationToken) {
            this.putUserInfo(attributes, authentication.getPrincipal());
        }
        if (authentication instanceof OAuth2AccessTokenAuthenticationToken) {
            Object details = authentication.getDetails();
            this.putUserInfo(attributes, details);
        }
        attributes.put("license", "Apache-2.0 Licensed | Copyright \u00a9 2020-2023 \u7801 \u5320 \u541b");
    }

    private void putUserInfo(Map<String, Object> attributes, Object object) {
        if (ObjectUtils.isNotEmpty((Object)object) && object instanceof HerodotusUser) {
            HerodotusUser principal = (HerodotusUser)object;
            attributes.put("openid", principal.getUserId());
            attributes.put("roles", principal.getRoles());
            attributes.put("avatar", principal.getAvatar());
            attributes.put("employeeId", principal.getEmployeeId());
        }
    }
}

