/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.provider;

import cn.herodotus.engine.captcha.core.dto.Verification;
import cn.herodotus.engine.captcha.core.exception.CaptchaHasExpiredException;
import cn.herodotus.engine.captcha.core.exception.CaptchaIsEmptyException;
import cn.herodotus.engine.captcha.core.exception.CaptchaMismatchException;
import cn.herodotus.engine.captcha.core.exception.CaptchaParameterIllegalException;
import cn.herodotus.engine.captcha.core.processor.CaptchaRendererFactory;
import cn.herodotus.engine.oauth2.authentication.provider.OAuth2FormLoginAuthenticationToken;
import cn.herodotus.engine.oauth2.core.definition.details.FormLoginWebAuthenticationDetails;
import cn.herodotus.engine.oauth2.core.exception.OAuth2CaptchaArgumentIllegalException;
import cn.herodotus.engine.oauth2.core.exception.OAuth2CaptchaHasExpiredException;
import cn.herodotus.engine.oauth2.core.exception.OAuth2CaptchaIsEmptyException;
import cn.herodotus.engine.oauth2.core.exception.OAuth2CaptchaMismatchException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;

public class OAuth2FormLoginAuthenticationProvider
extends DaoAuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(OAuth2FormLoginAuthenticationProvider.class);
    private final CaptchaRendererFactory captchaRendererFactory;

    public OAuth2FormLoginAuthenticationProvider(CaptchaRendererFactory captchaRendererFactory) {
        this.captchaRendererFactory = captchaRendererFactory;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        FormLoginWebAuthenticationDetails formLoginWebAuthenticationDetails;
        Object details = authentication.getDetails();
        if (ObjectUtils.isNotEmpty((Object)details) && details instanceof FormLoginWebAuthenticationDetails && !(formLoginWebAuthenticationDetails = (FormLoginWebAuthenticationDetails)details).getClosed().booleanValue()) {
            String code = formLoginWebAuthenticationDetails.getCode();
            String category = formLoginWebAuthenticationDetails.getCategory();
            String identity = formLoginWebAuthenticationDetails.getIdentity();
            if (StringUtils.isBlank((CharSequence)code)) {
                throw new OAuth2CaptchaIsEmptyException("Captcha is empty.");
            }
            try {
                Verification verification = new Verification();
                verification.setCharacters(code);
                verification.setCategory(category);
                verification.setIdentity(identity);
                this.captchaRendererFactory.verify(verification);
            }
            catch (CaptchaParameterIllegalException e) {
                throw new OAuth2CaptchaArgumentIllegalException("Captcha argument is illegal!");
            }
            catch (CaptchaHasExpiredException e) {
                throw new OAuth2CaptchaHasExpiredException("Captcha is expired!");
            }
            catch (CaptchaMismatchException e) {
                throw new OAuth2CaptchaMismatchException("Captcha is mismatch!");
            }
            catch (CaptchaIsEmptyException e) {
                throw new OAuth2CaptchaIsEmptyException("Captcha is empty!");
            }
        }
        super.additionalAuthenticationChecks(userDetails, authentication);
    }

    public boolean supports(Class<?> authentication) {
        boolean supports = OAuth2FormLoginAuthenticationToken.class.isAssignableFrom(authentication);
        log.trace("[Herodotus] |- Form Login Authentication is supports! [{}]", (Object)supports);
        return supports;
    }
}

