/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.provider;

import cn.herodotus.engine.assistant.core.utils.type.ListUtils;
import cn.herodotus.engine.oauth2.authentication.utils.OAuth2EndpointUtils;
import cn.herodotus.engine.rest.core.exception.SessionInvalidException;
import cn.herodotus.engine.rest.protect.crypto.processor.HttpCryptoProcessor;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;

public abstract class AbstractAuthenticationConverter
implements AuthenticationConverter {
    private final HttpCryptoProcessor httpCryptoProcessor;

    public AbstractAuthenticationConverter(HttpCryptoProcessor httpCryptoProcessor) {
        this.httpCryptoProcessor = httpCryptoProcessor;
    }

    protected String[] decrypt(String sessionId, List<String> parameters) {
        if (StringUtils.isNotBlank((CharSequence)sessionId) && CollectionUtils.isNotEmpty(parameters)) {
            List<String> result = parameters.stream().map(item -> this.decrypt(sessionId, (String)item)).toList();
            return ListUtils.toStringArray(result);
        }
        return ListUtils.toStringArray(parameters);
    }

    protected String decrypt(String sessionId, String parameter) {
        if (StringUtils.isNotBlank((CharSequence)sessionId) && StringUtils.isNotBlank((CharSequence)parameter)) {
            try {
                return this.httpCryptoProcessor.decrypt(sessionId, parameter);
            }
            catch (SessionInvalidException e) {
                OAuth2EndpointUtils.throwError("SessionExpiredException", e.getMessage(), "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
            }
        }
        return parameter;
    }
}

