/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.provider;

import cn.herodotus.engine.assistant.core.enums.AccountType;
import cn.herodotus.engine.assistant.core.utils.SessionUtils;
import cn.herodotus.engine.oauth2.authentication.provider.AbstractAuthenticationConverter;
import cn.herodotus.engine.oauth2.authentication.provider.OAuth2SocialCredentialsAuthenticationToken;
import cn.herodotus.engine.oauth2.authentication.utils.OAuth2EndpointUtils;
import cn.herodotus.engine.oauth2.core.definition.HerodotusGrantType;
import cn.herodotus.engine.rest.protect.crypto.processor.HttpCryptoProcessor;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class OAuth2SocialCredentialsAuthenticationConverter
extends AbstractAuthenticationConverter {
    public OAuth2SocialCredentialsAuthenticationConverter(HttpCryptoProcessor httpCryptoProcessor) {
        super(httpCryptoProcessor);
    }

    public Authentication convert(HttpServletRequest request) {
        AccountType accountType;
        String source;
        String grantType = request.getParameter("grant_type");
        if (!HerodotusGrantType.SOCIAL.getValue().equals(grantType)) {
            return null;
        }
        Authentication clientPrincipal = SecurityContextHolder.getContext().getAuthentication();
        MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getParameters(request);
        String scope = OAuth2EndpointUtils.checkOptionalParameter(parameters, "scope");
        HashSet<String> requestedScopes = null;
        if (StringUtils.hasText((String)scope)) {
            requestedScopes = new HashSet<String>(Arrays.asList(StringUtils.delimitedListToStringArray((String)scope, (String)" ")));
        }
        if (StringUtils.hasText((String)(source = OAuth2EndpointUtils.checkRequiredParameter(parameters, "source"))) && ObjectUtils.isNotEmpty((Object)(accountType = AccountType.getAccountType((String)source)))) {
            switch (accountType.getHandler()) {
                case "PHONE_NUMBER": {
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "mobile");
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "code");
                    break;
                }
                case "WECHAT_MINI_APP": {
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "appId");
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "sessionKey");
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "encryptedData");
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "iv");
                    break;
                }
            }
        }
        String sessionId = SessionUtils.analyseSessionId((HttpServletRequest)request);
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
        parameters.forEach((key, value) -> {
            if (!key.equals("grant_type") && !key.equals("scope")) {
                additionalParameters.put((String)key, value.size() == 1 ? this.decrypt(sessionId, (String)value.get(0)) : this.decrypt(sessionId, (List<String>)value));
            }
        });
        return new OAuth2SocialCredentialsAuthenticationToken(clientPrincipal, requestedScopes, additionalParameters);
    }
}

