/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.configuration;

import cn.herodotus.engine.oauth2.authentication.form.OAuth2FormLoginUrlConfigurer;
import cn.herodotus.engine.oauth2.authentication.properties.OAuth2AuthenticationProperties;
import cn.herodotus.engine.oauth2.authentication.stamp.LockedUserDetailsStampManager;
import cn.herodotus.engine.oauth2.authentication.stamp.SignInFailureLimitedStampManager;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OAuth2AuthenticationProperties.class})
public class OAuth2AuthenticationConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OAuth2AuthenticationConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [OAuth2 Authentication] Auto Configure.");
    }

    @Bean
    public LockedUserDetailsStampManager lockedUserDetailsStampManager(OAuth2AuthenticationProperties authenticationProperties) {
        LockedUserDetailsStampManager manager = new LockedUserDetailsStampManager(authenticationProperties);
        log.trace("[Herodotus] |- Bean [Locked UserDetails Stamp Manager] Auto Configure.");
        return manager;
    }

    @Bean
    public SignInFailureLimitedStampManager signInFailureLimitedStampManager(OAuth2AuthenticationProperties authenticationProperties) {
        SignInFailureLimitedStampManager manager = new SignInFailureLimitedStampManager(authenticationProperties);
        log.trace("[Herodotus] |- Bean [SignIn Failure Limited Stamp Manager] Auto Configure.");
        return manager;
    }

    @Bean
    public OAuth2FormLoginUrlConfigurer auth2FormLoginParameterConfigurer(OAuth2AuthenticationProperties authenticationProperties) {
        OAuth2FormLoginUrlConfigurer configurer = new OAuth2FormLoginUrlConfigurer(authenticationProperties);
        log.trace("[Herodotus] |- Bean [OAuth2 FormLogin Parameter Configurer] Auto Configure.");
        return configurer;
    }
}

