/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.customizer;

import cn.herodotus.engine.oauth2.core.definition.domain.HerodotusUser;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AccessTokenAuthenticationToken;

public abstract class AbstractTokenCustomizer {
    protected void appendAll(Map<String, Object> attributes, Authentication authentication, Set<String> authorizedScopes) {
        this.appendAuthorities(attributes, authentication);
        this.appendCommons(attributes, authentication, authorizedScopes);
    }

    protected void appendAuthorities(Map<String, Object> attributes, Authentication authentication) {
        if (CollectionUtils.isNotEmpty((Collection)authentication.getAuthorities())) {
            Set authorities = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
            attributes.put("authorities", authorities);
        }
    }

    protected void appendCommons(Map<String, Object> attributes, Authentication authentication, Set<String> authorizedScopes) {
        Object details;
        if (CollectionUtils.isNotEmpty(authorizedScopes)) {
            attributes.put("scope", authorizedScopes);
        }
        if (authentication instanceof UsernamePasswordAuthenticationToken) {
            HerodotusUser principal = (HerodotusUser)authentication.getPrincipal();
            this.putUserInfo(attributes, principal);
        }
        if (authentication instanceof OAuth2AccessTokenAuthenticationToken && ObjectUtils.isNotEmpty((Object)(details = authentication.getDetails())) && details instanceof HerodotusUser) {
            HerodotusUser principal = (HerodotusUser)details;
            this.putUserInfo(attributes, principal);
        }
        attributes.put("license", "Apache-2.0 Licensed | Copyright \u00a9 2020-2023 \u7801 \u5320 \u541b");
    }

    private void putUserInfo(Map<String, Object> attributes, HerodotusUser principal) {
        attributes.put("openid", principal.getUserId());
        attributes.put("roles", principal.getRoles());
        attributes.put("avatar", principal.getAvatar());
        attributes.put("employeeId", principal.getEmployeeId());
    }
}

