/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.provider;

import cn.herodotus.engine.assistant.core.enums.AccountType;
import cn.herodotus.engine.oauth2.authentication.provider.OAuth2SocialCredentialsAuthenticationToken;
import cn.herodotus.engine.oauth2.authentication.utils.OAuth2EndpointUtils;
import cn.herodotus.engine.oauth2.core.definition.HerodotusGrantType;
import cn.herodotus.engine.rest.core.exception.SessionInvalidException;
import cn.herodotus.engine.rest.protect.crypto.processor.HttpCryptoProcessor;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.MultiValueMap;

public class OAuth2SocialCredentialsAuthenticationConverter
implements AuthenticationConverter {
    private final HttpCryptoProcessor httpCryptoProcessor;

    public OAuth2SocialCredentialsAuthenticationConverter(HttpCryptoProcessor httpCryptoProcessor) {
        this.httpCryptoProcessor = httpCryptoProcessor;
    }

    public Authentication convert(HttpServletRequest request) {
        Authentication clientPrincipal;
        AccountType accountType;
        String source;
        String grantType = request.getParameter("grant_type");
        if (!HerodotusGrantType.SOCIAL.getValue().equals(grantType)) {
            return null;
        }
        MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getParameters(request);
        String scope = OAuth2EndpointUtils.checkOptionalParameter(parameters, "scope");
        HashSet<String> requestedScopes = null;
        if (org.springframework.util.StringUtils.hasText((String)scope)) {
            requestedScopes = new HashSet<String>(Arrays.asList(org.springframework.util.StringUtils.delimitedListToStringArray((String)scope, (String)" ")));
        }
        if (org.springframework.util.StringUtils.hasText((String)(source = OAuth2EndpointUtils.checkRequiredParameter(parameters, "source"))) && ObjectUtils.isNotEmpty((Object)(accountType = AccountType.getAccountType((String)source)))) {
            switch (accountType.getHandler()) {
                case "PHONE_NUMBER": {
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "mobile");
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "code");
                    break;
                }
                case "WECHAT_MINI_APP": {
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "appId");
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "sessionKey");
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "encryptedData");
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "iv");
                    break;
                }
            }
        }
        if ((clientPrincipal = SecurityContextHolder.getContext().getAuthentication()) == null) {
            OAuth2EndpointUtils.throwError("invalid_request", "invalid_client", "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
        }
        String sessionId = request.getHeader("X-Herodotus-Session");
        Map<String, Object> additionalParameters = parameters.entrySet().stream().filter(e -> !((String)e.getKey()).equals("grant_type") && !((String)e.getKey()).equals("scope")).collect(Collectors.toMap(Map.Entry::getKey, e -> this.parameterDecrypt(((List)e.getValue()).get(0), sessionId)));
        return new OAuth2SocialCredentialsAuthenticationToken(clientPrincipal, requestedScopes, additionalParameters);
    }

    private Object parameterDecrypt(Object object, String sessionId) {
        if (StringUtils.isNotBlank((CharSequence)sessionId) && ObjectUtils.isNotEmpty((Object)object) && object instanceof String) {
            try {
                return this.httpCryptoProcessor.decrypt(sessionId, object.toString());
            }
            catch (SessionInvalidException e) {
                OAuth2EndpointUtils.throwError("SessionExpiredException", e.getMessage(), "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
            }
        }
        return object;
    }
}

