/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.form;

import cn.herodotus.engine.oauth2.authentication.form.OAuth2FormLoginAuthenticationToken;
import cn.herodotus.engine.oauth2.core.utils.SymmetricUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class OAuth2FormLoginAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    private boolean postOnly = true;
    private static final Logger log = LoggerFactory.getLogger(OAuth2FormLoginAuthenticationFilter.class);

    public OAuth2FormLoginAuthenticationFilter() {
    }

    public OAuth2FormLoginAuthenticationFilter(AuthenticationManager authenticationManager) {
        super(authenticationManager);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        if (this.postOnly && !request.getMethod().equals("POST")) {
            throw new AuthenticationServiceException("Authentication method not supported: " + request.getMethod());
        }
        OAuth2FormLoginAuthenticationToken authRequest = this.getAuthenticationToken(request);
        this.setDetails(request, authRequest);
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    private OAuth2FormLoginAuthenticationToken getAuthenticationToken(HttpServletRequest request) {
        String username = this.obtainUsername(request);
        String password = this.obtainPassword(request);
        String key = request.getParameter("symmetric");
        if (StringUtils.isBlank((CharSequence)username)) {
            username = "";
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            password = "";
        }
        if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
            byte[] byteKey = SymmetricUtils.getDecryptedSymmetricKey((String)key);
            username = SymmetricUtils.decrypt((String)username, (byte[])byteKey);
            password = SymmetricUtils.decrypt((String)password, (byte[])byteKey);
            log.debug("[Herodotus] |- Decrypt Username is : [{}], Password is : [{}]", (Object)username, (Object)password);
        }
        return new OAuth2FormLoginAuthenticationToken(username, password);
    }

    public void setPostOnly(boolean postOnly) {
        super.setPostOnly(postOnly);
        this.postOnly = postOnly;
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        SecurityContextHolder.clearContext();
        this.getRememberMeServices().loginFail(request, response);
        this.getFailureHandler().onAuthenticationFailure(request, response, failed);
    }
}

