/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.oidc;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcUserInfoAuthenticationContext;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcUserInfoAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class HerodotusOidcUserInfoMapper
implements Function<OidcUserInfoAuthenticationContext, OidcUserInfo> {
    private static final List<String> EMAIL_CLAIMS = Arrays.asList("email", "email_verified");
    private static final List<String> PHONE_CLAIMS = Arrays.asList("phone_number", "phone_number_verified");
    private static final List<String> PROFILE_CLAIMS = Arrays.asList("name", "family_name", "given_name", "middle_name", "nickname", "preferred_username", "profile", "picture", "website", "gender", "birthdate", "zoneinfo", "locale", "updated_at");

    @Override
    public OidcUserInfo apply(OidcUserInfoAuthenticationContext authenticationContext) {
        OidcUserInfoAuthenticationToken authentication = (OidcUserInfoAuthenticationToken)authenticationContext.getAuthentication();
        if (authentication.getPrincipal() instanceof BearerTokenAuthentication) {
            BearerTokenAuthentication principal = (BearerTokenAuthentication)authentication.getPrincipal();
            return new OidcUserInfo(HerodotusOidcUserInfoMapper.getClaims(principal.getTokenAttributes()));
        }
        JwtAuthenticationToken principal = (JwtAuthenticationToken)authentication.getPrincipal();
        return new OidcUserInfo(HerodotusOidcUserInfoMapper.getClaims(((Jwt)principal.getToken()).getClaims()));
    }

    private static Map<String, Object> getClaims(Map<String, Object> claims) {
        HashSet<String> needRemovedClaims = new HashSet<String>(32);
        needRemovedClaims.add("authorities");
        HashMap<String, Object> requestedClaims = new HashMap<String, Object>(claims);
        requestedClaims.keySet().removeIf(needRemovedClaims::contains);
        return requestedClaims;
    }
}

