/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authentication.form;

import cn.herodotus.engine.captcha.core.processor.CaptchaRendererFactory;
import cn.herodotus.engine.oauth2.authentication.form.OAuth2FormLoginAuthenticationFilter;
import cn.herodotus.engine.oauth2.authentication.form.OAuth2FormLoginAuthenticationProvider;
import cn.herodotus.engine.oauth2.authentication.form.OAuth2FormLoginWebAuthenticationDetailSource;
import cn.herodotus.engine.oauth2.authentication.properties.OAuth2UiProperties;
import cn.herodotus.engine.oauth2.authentication.response.OAuth2FormLoginAuthenticationFailureHandler;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class OAuth2FormLoginConfigurer
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private static final Logger log = LoggerFactory.getLogger(OAuth2FormLoginConfigurer.class);
    private final UserDetailsService userDetailsService;
    private final OAuth2UiProperties uiProperties;
    private final CaptchaRendererFactory captchaRendererFactory;

    public OAuth2FormLoginConfigurer(UserDetailsService userDetailsService, OAuth2UiProperties uiProperties, CaptchaRendererFactory captchaRendererFactory) {
        this.userDetailsService = userDetailsService;
        this.uiProperties = uiProperties;
        this.captchaRendererFactory = captchaRendererFactory;
    }

    public void configure(HttpSecurity httpSecurity) throws Exception {
        AuthenticationManager authenticationManager = (AuthenticationManager)httpSecurity.getSharedObject(AuthenticationManager.class);
        OAuth2FormLoginAuthenticationFilter filter = new OAuth2FormLoginAuthenticationFilter(authenticationManager);
        filter.setUsernameParameter(this.uiProperties.getUsernameParameter());
        filter.setPasswordParameter(this.uiProperties.getPasswordParameter());
        filter.setAuthenticationDetailsSource(new OAuth2FormLoginWebAuthenticationDetailSource(this.uiProperties));
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)new OAuth2FormLoginAuthenticationFailureHandler(this.uiProperties.getFailureForwardUrl()));
        OAuth2FormLoginAuthenticationProvider provider = new OAuth2FormLoginAuthenticationProvider(this.captchaRendererFactory);
        provider.setUserDetailsService(this.userDetailsService);
        provider.setHideUserNotFoundExceptions(false);
        httpSecurity.authenticationProvider((AuthenticationProvider)provider).addFilterBefore((Filter)filter, UsernamePasswordAuthenticationFilter.class);
    }
}

