/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.resource.autoconfigure.metadata;

import cn.herodotus.engine.assistant.core.json.jackson2.utils.Jackson2Utils;
import cn.herodotus.engine.oauth2.authorization.processor.SecurityMetadataSourceAnalyzer;
import cn.herodotus.engine.oauth2.core.definition.domain.SecurityAttribute;
import cn.herodotus.engine.oauth2.resource.autoconfigure.bus.RemoteSecurityMetadataSyncEvent;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bus.ServiceMatcher;
import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.context.ApplicationListener;

public class RemoteSecurityMetadataSyncListener
implements ApplicationListener<RemoteSecurityMetadataSyncEvent> {
    private static final Logger log = LoggerFactory.getLogger(RemoteSecurityMetadataSyncListener.class);
    private final SecurityMetadataSourceAnalyzer securityMetadataSourceAnalyzer;
    private final ServiceMatcher serviceMatcher;

    public RemoteSecurityMetadataSyncListener(SecurityMetadataSourceAnalyzer securityMetadataSourceAnalyzer, ServiceMatcher serviceMatcher) {
        this.securityMetadataSourceAnalyzer = securityMetadataSourceAnalyzer;
        this.serviceMatcher = serviceMatcher;
    }

    public void onApplicationEvent(RemoteSecurityMetadataSyncEvent event) {
        if (!this.serviceMatcher.isFromSelf((RemoteApplicationEvent)event)) {
            List securityMetadata;
            log.info("[Herodotus] |- Remote security metadata sync listener, response service [{}] event!", (Object)event.getOriginService());
            String data = event.getData();
            if (StringUtils.isNotBlank((CharSequence)data) && CollectionUtils.isNotEmpty((Collection)(securityMetadata = Jackson2Utils.toList((String)data, SecurityAttribute.class)))) {
                log.debug("[Herodotus] |- Got security attributes from service [{}], current [{}] start to process security attributes.", (Object)event.getOriginService(), (Object)event.getDestinationService());
                this.securityMetadataSourceAnalyzer.processSecurityAttribute(securityMetadata);
            }
        }
    }
}

