/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.resource.autoconfigure;

import cn.herodotus.engine.oauth2.resource.autoconfigure.stream.StreamMessageSendingAdapter;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.cloud.stream.function.FunctionConfiguration;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={FunctionConfiguration.class})
@ConditionalOnBean(value={StreamBridge.class})
public class StreamAdapterAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(StreamAdapterAutoConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.info("[Herodotus] |- Module [Stream Adapter] Auto Configure.");
    }

    @Bean
    public StreamMessageSendingAdapter streamMessageSendingAdapter(StreamBridge streamBridge) {
        StreamMessageSendingAdapter adapter = new StreamMessageSendingAdapter(streamBridge);
        log.trace("[Herodotus] |- Bean [Stream Message Sending Adapter] Auto Configure.");
        return adapter;
    }
}

