/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.resource.autoconfigure.scan;

import cn.herodotus.engine.assistant.core.context.ServiceContextHolder;
import cn.herodotus.engine.message.core.logic.domain.RequestMapping;
import cn.herodotus.engine.message.core.logic.event.RequestMappingGatherEvent;
import cn.herodotus.engine.message.core.logic.strategy.RequestMappingScanEventManager;
import cn.herodotus.engine.oauth2.authorization.processor.SecurityMetadataSourceAnalyzer;
import cn.herodotus.engine.oauth2.resource.autoconfigure.bus.RemoteRequestMappingGatherEvent;
import java.lang.annotation.Annotation;
import java.util.List;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.stereotype.Component;

@Component
public class DefaultRequestMappingScanEventManager
implements RequestMappingScanEventManager {
    private final SecurityMetadataSourceAnalyzer securityMetadataSourceAnalyzer;

    public DefaultRequestMappingScanEventManager(SecurityMetadataSourceAnalyzer securityMetadataSourceAnalyzer) {
        this.securityMetadataSourceAnalyzer = securityMetadataSourceAnalyzer;
    }

    public Class<? extends Annotation> getScanAnnotationClass() {
        return EnableWebSecurity.class;
    }

    public String getDestinationServiceName() {
        return ServiceContextHolder.getInstance().getUpmsServiceName();
    }

    public void postLocalStorage(List<RequestMapping> requestMappings) {
        this.securityMetadataSourceAnalyzer.processRequestMatchers();
    }

    public void postLocalProcess(List<RequestMapping> data) {
        this.publishEvent((ApplicationEvent)new RequestMappingGatherEvent(data));
    }

    public void postRemoteProcess(String data, String originService, String destinationService) {
        this.publishEvent((ApplicationEvent)new RemoteRequestMappingGatherEvent(data, originService, destinationService));
    }
}

