/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authorization.servlet;

import cn.herodotus.engine.core.autoconfigure.oauth2.OAuth2AuthorizationProperties;
import cn.herodotus.engine.core.autoconfigure.oauth2.constant.TokenFormat;
import cn.herodotus.engine.oauth2.authorization.servlet.HerodotusJwtAuthenticationConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.DefaultBearerTokenResolver;

public class OAuth2ResourceServerConfigurerCustomer
implements Customizer<OAuth2ResourceServerConfigurer<HttpSecurity>> {
    private final JwtDecoder jwtDecoder;
    private final OAuth2AuthorizationProperties authorizationProperties;
    private final OpaqueTokenIntrospector opaqueTokenIntrospector;

    public OAuth2ResourceServerConfigurerCustomer(OAuth2AuthorizationProperties authorizationProperties, JwtDecoder jwtDecoder, OpaqueTokenIntrospector opaqueTokenIntrospector) {
        this.jwtDecoder = jwtDecoder;
        this.authorizationProperties = authorizationProperties;
        this.opaqueTokenIntrospector = opaqueTokenIntrospector;
    }

    private boolean isRemoteValidate() {
        return this.authorizationProperties.getTokenFormat() == TokenFormat.OPAQUE;
    }

    public void customize(OAuth2ResourceServerConfigurer<HttpSecurity> configurer) {
        if (this.isRemoteValidate()) {
            configurer.opaqueToken(opaque -> opaque.introspector(this.opaqueTokenIntrospector));
        } else {
            configurer.jwt(jwt -> jwt.decoder(this.jwtDecoder).jwtAuthenticationConverter((Converter)new HerodotusJwtAuthenticationConverter())).bearerTokenResolver((BearerTokenResolver)new DefaultBearerTokenResolver());
        }
    }
}

