/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.oauth2.authorization.config;

import cn.herodotus.engine.core.autoconfigure.oauth2.OAuth2AuthorizationProperties;
import cn.herodotus.engine.core.autoconfigure.oauth2.servlet.ServletOAuth2ResourceMatcherConfigurer;
import cn.herodotus.engine.core.foundation.condition.ConditionalOnServletApplication;
import cn.herodotus.engine.oauth2.authorization.config.OAuth2ServletSessionConfiguration;
import cn.herodotus.engine.oauth2.authorization.processor.SecurityAttributeAnalyzer;
import cn.herodotus.engine.oauth2.authorization.processor.SecurityAttributeStorage;
import cn.herodotus.engine.oauth2.authorization.servlet.OAuth2SessionManagementConfigurerCustomer;
import cn.herodotus.engine.oauth2.authorization.servlet.ServletOAuth2AuthorizationConfigurerManager;
import cn.herodotus.engine.oauth2.authorization.servlet.ServletSecurityAuthorizationManager;
import cn.herodotus.engine.web.core.servlet.template.ThymeleafTemplateHandler;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;

@Configuration(proxyBeanMethods=false)
@ConditionalOnServletApplication
@EnableMethodSecurity(proxyTargetClass=true, securedEnabled=true, jsr250Enabled=true)
@Import(value={OAuth2ServletSessionConfiguration.class})
public class OAuth2ServletAuthorizationConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OAuth2ServletAuthorizationConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [OAuth2 Servlet Authorization] Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public SecurityAttributeStorage securityMetadataSourceStorage() {
        return new SecurityAttributeStorage();
    }

    @Bean
    @ConditionalOnMissingBean
    public ServletSecurityAuthorizationManager servletSecurityAuthorizationManager(SecurityAttributeStorage securityAttributeStorage, ServletOAuth2ResourceMatcherConfigurer servletOAuth2ResourceMatcherConfigurer) {
        ServletSecurityAuthorizationManager manager = new ServletSecurityAuthorizationManager(securityAttributeStorage, servletOAuth2ResourceMatcherConfigurer);
        log.trace("[Herodotus] |- Bean [Servlet Security Authorization Manager] Configure.");
        return manager;
    }

    @Bean
    @ConditionalOnMissingBean
    public SecurityAttributeAnalyzer securityAttributeAnalyzer(SecurityAttributeStorage securityAttributeStorage, ServletOAuth2ResourceMatcherConfigurer servletOAuth2ResourceMatcherConfigurer) {
        SecurityAttributeAnalyzer analyzer = new SecurityAttributeAnalyzer(securityAttributeStorage, servletOAuth2ResourceMatcherConfigurer);
        log.trace("[Herodotus] |- Bean [Security Attribute Analyzer] Configure.");
        return analyzer;
    }

    @Bean
    @ConditionalOnMissingBean
    public ServletOAuth2AuthorizationConfigurerManager servletOAuth2AuthorizationFacadeConfigurer(ThymeleafTemplateHandler thymeleafTemplateHandler, OAuth2AuthorizationProperties oauth2AuthorizationProperties, JwtDecoder jwtDecoder, OpaqueTokenIntrospector opaqueTokenIntrospector, OAuth2SessionManagementConfigurerCustomer sessionManagementConfigurerCustomer, ServletOAuth2ResourceMatcherConfigurer servletOAuth2ResourceMatcherConfigurer, ServletSecurityAuthorizationManager servletSecurityAuthorizationManager) {
        ServletOAuth2AuthorizationConfigurerManager configurer = new ServletOAuth2AuthorizationConfigurerManager(thymeleafTemplateHandler, oauth2AuthorizationProperties, jwtDecoder, opaqueTokenIntrospector, sessionManagementConfigurerCustomer, servletOAuth2ResourceMatcherConfigurer, servletSecurityAuthorizationManager);
        log.trace("[Herodotus] |- Bean [Servlet OAuth2 Resource Server Configurer] Configure.");
        return configurer;
    }
}

